/*
 * Decompiled with CFR 0.152.
 */
package fabric.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import fabric.dev.mrsnowy.teleport_commands.Constants;
import fabric.dev.mrsnowy.teleport_commands.suggestions.tpaSuggestionProvider;
import fabric.dev.mrsnowy.teleport_commands.utils.tools;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class tpa {
    public static final ArrayList<tpaArrayClass> tpaList = new ArrayList();

    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 TargetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                tpa.tpaCommandHandler(player, TargetPlayer, false);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while sending a tpa request! => ", (Throwable)e);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpahere").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 TargetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                tpa.tpaCommandHandler(player, TargetPlayer, true);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while sending a tpahere request! => ", (Throwable)e);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaaccept").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).suggests((SuggestionProvider)new tpaSuggestionProvider()).executes(context -> {
            class_3222 TargetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                tpa.tpaAccept(player, TargetPlayer);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while accepting a tpa(here) request! => ", (Throwable)e);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpadeny").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).suggests((SuggestionProvider)new tpaSuggestionProvider()).executes(context -> {
            class_3222 TargetPlayer = class_2186.method_9315((CommandContext)context, (String)"player");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                tpa.tpaDeny(player, TargetPlayer);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while denying a tpa(here) request! => ", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.home.setError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
    }

    private static void tpaCommandHandler(final class_3222 FromPlayer, final class_3222 ToPlayer, boolean here) throws NullPointerException {
        long playerTpaList = tpaList.stream().filter(tpa2 -> Objects.equals(FromPlayer.method_5845(), tpa2.InitPlayer)).filter(tpa2 -> Objects.equals(ToPlayer.method_5845(), tpa2.RecPlayer)).count();
        if (FromPlayer == ToPlayer) {
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.self", FromPlayer, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else if (playerTpaList >= 1L) {
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.alreadySent", FromPlayer, class_2561.method_43470((String)Objects.requireNonNull(ToPlayer.method_5477().getString(), "ToPlayer name cannot be null")).method_27692(class_124.field_1067)).method_27692(class_124.field_1075), true);
        } else {
            final String hereText = here ? "Here" : "";
            final tpaArrayClass tpaRequest = new tpaArrayClass(FromPlayer.method_5845(), ToPlayer.method_5845(), here);
            String ReceivedFromPlayer = Objects.requireNonNull(FromPlayer.method_5477().getString(), "FromPlayer name cannot be null");
            String SentToPlayer = Objects.requireNonNull(ToPlayer.method_5477().getString(), "ToPlayer name cannot be null");
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.sent", FromPlayer, class_2561.method_43470((String)hereText), class_2561.method_43470((String)SentToPlayer).method_27692(class_124.field_1067)), true);
            ToPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.received", ToPlayer, class_2561.method_43470((String)hereText), class_2561.method_43470((String)ReceivedFromPlayer).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_27692(class_124.field_1075).method_27693("\n").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.accept", ToPlayer, new class_5250[0]).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(String.format("/tpaaccept %s", ReceivedFromPlayer))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.deny", ToPlayer, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(String.format("/tpadeny %s", ReceivedFromPlayer))))), false);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    boolean successful = tpaList.remove(tpaRequest);
                    if (successful) {
                        FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.expired", FromPlayer, class_2561.method_43470((String)hereText)).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                        ToPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.expired", ToPlayer, class_2561.method_43470((String)hereText)).method_27692(class_124.field_1068), true);
                    }
                }
            }, 30000L);
        }
    }

    private static void tpaAccept(class_3222 FromPlayer, class_3222 ToPlayer) {
        if (FromPlayer == ToPlayer) {
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.self", FromPlayer, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        Optional<tpaArrayClass> tpaStorage = tpaList.stream().filter(tpa2 -> Objects.equals(ToPlayer.method_5845(), tpa2.InitPlayer)).filter(tpa2 -> Objects.equals(FromPlayer.method_5845(), tpa2.RecPlayer)).findFirst();
        if (tpaStorage.isPresent()) {
            class_3222 destinationPlayer = tpaStorage.get().here ? ToPlayer : FromPlayer;
            class_3222 toSentPlayer = tpaStorage.get().here ? FromPlayer : ToPlayer;
            Optional<class_2338> teleportData = tools.getSafeBlockPos(destinationPlayer.method_24515(), destinationPlayer.method_51469());
            if (teleportData.isPresent()) {
                class_2338 safeBlockPos = teleportData.get();
                class_243 teleportPos = new class_243((double)safeBlockPos.method_10263() + 0.5, (double)safeBlockPos.method_10264(), (double)safeBlockPos.method_10260() + 0.5);
                tools.Teleporter(toSentPlayer, destinationPlayer.method_51469(), teleportPos);
            } else {
                tools.Teleporter(toSentPlayer, destinationPlayer.method_51469(), destinationPlayer.method_19538());
            }
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.accepted", FromPlayer, new class_5250[0]).method_27692(class_124.field_1068), true);
            ToPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.accepted", ToPlayer, new class_5250[0]).method_27692(class_124.field_1060), true);
            tpaList.remove(tpaStorage.get());
        } else {
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.notFound", FromPlayer, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void tpaDeny(class_3222 FromPlayer, class_3222 ToPlayer) {
        if (FromPlayer == ToPlayer) {
            FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.self", FromPlayer, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else {
            Optional<tpaArrayClass> tpaStorage = tpaList.stream().filter(tpa2 -> Objects.equals(ToPlayer.method_5845(), tpa2.InitPlayer)).filter(tpa2 -> Objects.equals(FromPlayer.method_5845(), tpa2.RecPlayer)).findFirst();
            if (tpaStorage.isPresent()) {
                tpaList.remove(tpaStorage.get());
                ToPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.denied", ToPlayer, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.denied", FromPlayer, new class_5250[0]).method_27692(class_124.field_1068), true);
            } else {
                FromPlayer.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.tpa.notFound", FromPlayer, new class_5250[0]).method_27692(class_124.field_1061), true);
            }
        }
    }

    public static class tpaArrayClass {
        public final String InitPlayer;
        public final String RecPlayer;
        final boolean here;

        public tpaArrayClass(String initPlayer, String recPlayer, boolean here) {
            this.InitPlayer = initPlayer;
            this.RecPlayer = recPlayer;
            this.here = here;
            tpaList.add(this);
        }
    }
}

