/*
 * Decompiled with CFR 0.152.
 */
package fabric.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import fabric.dev.mrsnowy.teleport_commands.Constants;
import fabric.dev.mrsnowy.teleport_commands.common.NamedLocation;
import fabric.dev.mrsnowy.teleport_commands.storage.StorageManager;
import fabric.dev.mrsnowy.teleport_commands.suggestions.WarpSuggestionProvider;
import fabric.dev.mrsnowy.teleport_commands.utils.tools;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class warp {
    public static void register(CommandDispatcher<class_2168> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").requires(source -> source.method_44023() != null && source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.SetWarp(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while setting the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.setError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").requires(source -> source.method_44023() != null)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.GoToWarp(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going to the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.goError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").requires(source -> source.method_44023() != null && source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.DeleteWarp(player, name);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while deleting to the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.deleteError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"renamewarp").requires(source -> source.method_44023() != null && source.method_9259(4))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WarpSuggestionProvider()).then(class_2170.method_9244((String)"newName", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.RenameWarp(player, name, newName);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while renaming the warp!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.renameError", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"warps").requires(source -> source.method_44023() != null)).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            try {
                warp.PrintWarps(player);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while printing warps!", (Throwable)e);
                player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warps.error", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
                return 1;
            }
            return 0;
        }));
    }

    private static void SetWarp(class_3222 player, String warpName) throws Exception {
        System.out.println(warpName);
        warpName = warpName.toLowerCase();
        class_2338 blockPos = new class_2338(player.method_31477(), player.method_31478(), player.method_31479());
        String worldString = player.method_51469().method_27983().method_29177().toString();
        NamedLocation warp2 = new NamedLocation(warpName, blockPos, worldString);
        boolean warpExists = StorageManager.STORAGE.addWarp(warp2);
        if (warpExists) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.exists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.set", player, new class_5250[0]), true);
        }
    }

    private static void GoToWarp(class_3222 player, String warpName) throws Exception {
        Optional<NamedLocation> optionalWarp = StorageManager.STORAGE.getWarp(warpName = warpName.toLowerCase());
        if (optionalWarp.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        NamedLocation warp2 = optionalWarp.get();
        Optional<class_3218> optionalWorld = warp2.getWorld();
        if (optionalWorld.isEmpty()) {
            Constants.LOGGER.warn("({}) Error while going to the warp \"{}\"! \nCouldn't find a world with the id: \"{}\" \nAvailable worlds: {}", new Object[]{player.method_5477().getString(), warp2.getName(), warp2.getWorldString(), tools.getWorldIds()});
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.worldNotFound", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), true);
            return;
        }
        class_3218 warpWorld = optionalWorld.get();
        class_2338 teleportBlockPos = warp2.getBlockPos();
        if (player.method_24515().equals((Object)teleportBlockPos) && player.method_37908() == warpWorld) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.goSame", player, new class_5250[0]).method_27692(class_124.field_1075), true);
        } else {
            class_243 teleportPos = new class_243((double)teleportBlockPos.method_10263() + 0.5, (double)teleportBlockPos.method_10264(), (double)teleportBlockPos.method_10260() + 0.5);
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.go", player, new class_5250[0]), true);
            tools.Teleporter(player, warpWorld, teleportPos);
        }
    }

    private static void DeleteWarp(class_3222 player, String warpName) throws Exception {
        Optional<NamedLocation> optionalWarp = StorageManager.STORAGE.getWarp(warpName = warpName.toLowerCase());
        if (optionalWarp.isPresent()) {
            StorageManager.STORAGE.removeWarp(optionalWarp.get());
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.delete", player, new class_5250[0]), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void RenameWarp(class_3222 player, String warpName, String newWarpName) throws Exception {
        warpName = warpName.toLowerCase();
        if (StorageManager.STORAGE.getWarp(newWarpName = newWarpName.toLowerCase()).isPresent()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.common.nameExists", player, new class_5250[0]).method_27692(class_124.field_1061), true);
            return;
        }
        Optional<NamedLocation> warpToRename = StorageManager.STORAGE.getWarp(warpName);
        if (warpToRename.isPresent()) {
            warpToRename.get().setName(newWarpName);
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.rename", player, new class_5250[0]), true);
        } else {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.notFound", player, new class_5250[0]).method_27692(class_124.field_1061), true);
        }
    }

    private static void PrintWarps(class_3222 player) throws Exception {
        List<NamedLocation> warps = StorageManager.STORAGE.getWarps();
        if (warps.isEmpty()) {
            player.method_7353((class_2561)tools.getTranslatedText("commands.teleport_commands.warp.homeless", player, new class_5250[0]).method_27692(class_124.field_1075), true);
            return;
        }
        class_5250 message = class_2561.method_43473();
        message.method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.warps.warps", player, new class_5250[0]).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        for (NamedLocation currentWarp : warps) {
            String name = String.format("  - %s", currentWarp.getName());
            String coords = String.format("[X%d Y%d Z%d]", currentWarp.getX(), currentWarp.getY(), currentWarp.getZ());
            String dimension = String.format(" [%s]", currentWarp.getWorldString());
            boolean canModify = player.method_64475(4);
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075));
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)coords).method_27692(class_124.field_1076).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(String.format("X%d Y%d Z%d", currentWarp.getX(), currentWarp.getY(), currentWarp.getZ())))).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new class_5250[0]))))).method_10852((class_2561)class_2561.method_43470((String)dimension).method_27692(class_124.field_1064).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10606(currentWarp.getWorldString()))).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)tools.getTranslatedText("commands.teleport_commands.common.hoverCopy", player, new class_5250[0])))));
            message.method_27693("\n");
            message.method_10852((class_2561)class_2561.method_43470((String)"     | ").method_27692(class_124.field_1075)).method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.tp", player, new class_5250[0]).method_27692(class_124.field_1060).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609(String.format("/warp \"%s\"", currentWarp.getName()))))).method_27693(" ");
            if (canModify) {
                message.method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.rename", player, new class_5250[0]).method_27692(class_124.field_1078).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(String.format("/renamewarp \"%s\" ", currentWarp.getName()))))).method_27693(" ").method_10852((class_2561)tools.getTranslatedText("commands.teleport_commands.common.delete", player, new class_5250[0]).method_27692(class_124.field_1061).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10610(String.format("/delwarp \"%s\"", currentWarp.getName())))));
            }
            message.method_27693("\n");
        }
        player.method_7353((class_2561)message, false);
    }
}

