/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.common.DeathLocation;
import neoforge.dev.mrsnowy.teleport_commands.storage.DeathLocationStorage;
import neoforge.dev.mrsnowy.teleport_commands.utils.tools;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class back {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(source -> source.getPlayer() != null)).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                back.ToDeathLocation(player, false);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going back! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.error", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"Disable Safety", (ArgumentType)BoolArgumentType.bool()).requires(source -> source.getPlayer() != null)).executes(context -> {
            boolean safety = BoolArgumentType.getBool((CommandContext)context, (String)"Disable Safety");
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            try {
                back.ToDeathLocation(player, safety);
            }
            catch (Exception e) {
                Constants.LOGGER.error("Error while going back! => ", (Throwable)e);
                player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.error", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
                return 1;
            }
            return 0;
        })));
    }

    private static void ToDeathLocation(ServerPlayer player, boolean safetyDisabled) throws Exception {
        BlockPos teleportBlockPos;
        DeathLocation deathLocation = DeathLocationStorage.getDeathLocation(player.getStringUUID()).orElse(null);
        if (deathLocation == null) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.noLocation", player, new MutableComponent[0]).withStyle(ChatFormatting.RED), true);
            return;
        }
        ServerLevel deathLocationWorld = deathLocation.getWorld().orElse(null);
        if (deathLocationWorld == null) {
            Constants.LOGGER.warn("({}) Error while going back! \nCouldn't find a world with the id: \"{}\" \nAvailable worlds: {}", new Object[]{player.getName().getString(), deathLocation.getWorldString(), tools.getWorldIds()});
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.common.worldNotFound", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), true);
            return;
        }
        if (!safetyDisabled) {
            Optional<BlockPos> safeBlockPos = tools.getSafeBlockPos(deathLocation.getBlockPos(), deathLocationWorld);
            if (safeBlockPos.isEmpty()) {
                player.displayClientMessage((Component)Component.empty().append((Component)tools.getTranslatedText("commands.teleport_commands.common.noSafeLocation", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})).append("\n").append((Component)tools.getTranslatedText("commands.teleport_commands.common.safetyIsForLosers", player, new MutableComponent[0]).withStyle(ChatFormatting.WHITE)).append("\n").append((Component)tools.getTranslatedText("commands.teleport_commands.common.forceTeleport", player, new MutableComponent[0]).withStyle(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.BOLD}).withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/back true")))).append("\n"), false);
                return;
            }
            teleportBlockPos = safeBlockPos.get();
        } else {
            teleportBlockPos = deathLocation.getBlockPos();
        }
        if (player.blockPosition().equals((Object)teleportBlockPos) && player.level() == deathLocationWorld) {
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.back.same", player, new MutableComponent[0]).withStyle(ChatFormatting.AQUA), true);
        } else {
            Vec3 teleportPos = new Vec3((double)teleportBlockPos.getX() + 0.5, (double)teleportBlockPos.getY(), (double)teleportBlockPos.getZ() + 0.5);
            player.displayClientMessage((Component)tools.getTranslatedText("commands.teleport_commands.back.go", player, new MutableComponent[0]), true);
            tools.Teleporter(player, deathLocationWorld, teleportPos);
        }
    }
}

