/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import neoforge.dev.mrsnowy.teleport_commands.common.NamedLocation;
import neoforge.dev.mrsnowy.teleport_commands.storage.StorageManager;

public class Player {
    private final String UUID;
    private String DefaultHome = "";
    private final ArrayList<NamedLocation> Homes = new ArrayList();

    public Player(String uuid) {
        this.UUID = uuid;
    }

    public String getUUID() {
        return this.UUID;
    }

    public String getDefaultHome() {
        return this.DefaultHome;
    }

    public List<NamedLocation> getHomes() {
        return Collections.unmodifiableList(this.Homes);
    }

    public Optional<NamedLocation> getHome(String name) {
        return this.Homes.stream().filter(home2 -> Objects.equals(home2.getName(), name)).findFirst();
    }

    public void setDefaultHome(String defaultHome) throws Exception {
        this.DefaultHome = defaultHome;
        StorageManager.StorageSaver();
    }

    public boolean addHome(NamedLocation home2) throws Exception {
        if (this.getHome(home2.getName()).isPresent()) {
            return true;
        }
        this.Homes.add(home2);
        StorageManager.StorageSaver();
        return false;
    }

    public void deleteHome(NamedLocation home2) throws Exception {
        this.Homes.remove(home2);
        StorageManager.StorageSaver();
    }
}

