/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.TeleportCommands;
import neoforge.dev.mrsnowy.teleport_commands.common.NamedLocation;
import neoforge.dev.mrsnowy.teleport_commands.common.Player;

public class StorageManager {
    public static Path STORAGE_FOLDER;
    public static Path STORAGE_FILE;
    public static StorageClass STORAGE;

    public static void StorageInit() {
        STORAGE_FOLDER = TeleportCommands.SAVE_DIR.resolve("TeleportCommands/");
        STORAGE_FILE = STORAGE_FOLDER.resolve("storage.json");
        try {
            if (!Files.exists(STORAGE_FOLDER, new LinkOption[0])) {
                Files.createDirectories(STORAGE_FOLDER, new FileAttribute[0]);
            }
            if (!Files.exists(STORAGE_FILE, new LinkOption[0])) {
                Files.createFile(STORAGE_FILE, new FileAttribute[0]);
            }
            if (new File(String.valueOf(STORAGE_FILE)).length() == 0L) {
                STORAGE = new StorageClass();
                StorageManager.StorageSaver();
            }
        }
        catch (Exception e) {
            Constants.LOGGER.error("Error while creating the storage file! Exiting! => ", (Throwable)e);
            System.exit(1);
        }
    }

    public static void StorageSaver() throws Exception {
        Gson gson = new GsonBuilder().create();
        byte[] json = gson.toJson((Object)STORAGE).getBytes();
        Files.write(STORAGE_FILE, json, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static class StorageClass {
        private final ArrayList<NamedLocation> Warps = new ArrayList();
        private final ArrayList<Player> Players = new ArrayList();

        public List<NamedLocation> getWarps() {
            return Collections.unmodifiableList(this.Warps);
        }

        public Optional<NamedLocation> getWarp(String name) {
            return this.Warps.stream().filter(warp2 -> Objects.equals(warp2.getName(), name)).findFirst();
        }

        public Optional<Player> getPlayer(String uuid) {
            return this.Players.stream().filter(player -> Objects.equals(player.getUUID(), uuid)).findFirst();
        }

        public boolean addWarp(NamedLocation warp2) throws Exception {
            if (this.getWarp(warp2.getName()).isPresent()) {
                return true;
            }
            this.Warps.add(warp2);
            StorageManager.StorageSaver();
            return false;
        }

        public Player addPlayer(String uuid) {
            Optional<Player> OptionalPlayer = this.getPlayer(uuid);
            if (OptionalPlayer.isEmpty()) {
                Player player = new Player(uuid);
                this.Players.add(player);
                return player;
            }
            return OptionalPlayer.get();
        }

        public void removeWarp(NamedLocation warp2) throws Exception {
            this.Warps.remove(warp2);
            StorageManager.StorageSaver();
        }
    }
}

