/*
 * Decompiled with CFR 0.152.
 */
package neoforge.dev.mrsnowy.teleport_commands.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import neoforge.dev.mrsnowy.teleport_commands.Constants;
import neoforge.dev.mrsnowy.teleport_commands.TeleportCommands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class tools {
    private static final Set<String> unsafeCollisionFreeBlocks = Set.of("block.minecraft.lava", "block.minecraft.flowing_lava", "block.minecraft.end_portal", "block.minecraft.end_gateway", "block.minecraft.fire", "block.minecraft.soul_fire", "block.minecraft.powder_snow", "block.minecraft.nether_portal");

    public static void Teleporter(final ServerPlayer player, final ServerLevel world, Vec3 coords) {
        world.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, player.getX(), player.getY() + 1.0, player.getZ(), 20, 0.0, 0.0, 0.0, 0.01);
        world.sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, player.getX(), player.getY(), player.getZ(), 15, 0.0, 1.0, 0.0, 0.03);
        world.playSound(null, player.blockPosition(), SoundEvent.createVariableRangeEvent((ResourceLocation)SoundEvents.ENDERMAN_TELEPORT.location()), SoundSource.PLAYERS, 0.4f, 1.0f);
        boolean flying = player.getAbilities().flying;
        player.teleportTo(world, coords.x, coords.y, coords.z, Set.of(), player.getYRot(), player.getXRot(), false);
        if (flying) {
            player.getAbilities().flying = true;
            player.onUpdateAbilities();
        }
        world.playSound(null, player.blockPosition(), SoundEvent.createVariableRangeEvent((ResourceLocation)SoundEvents.ENDERMAN_TELEPORT.location()), SoundSource.PLAYERS, 0.4f, 1.0f);
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                world.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, player.getX(), player.getY(), player.getZ(), 20, 0.0, 1.0, 0.0, 0.01);
                world.sendParticles((ParticleOptions)ParticleTypes.WHITE_SMOKE, player.getX(), player.getY(), player.getZ(), 15, 0.0, 0.0, 0.0, 0.03);
            }
        }, 100L);
    }

    public static Optional<BlockPos> getSafeBlockPos(BlockPos blockPos, ServerLevel world) {
        int rows = 3;
        int blockPosX = blockPos.getX();
        int blockPosY = blockPos.getY();
        int blockPosZ = blockPos.getZ();
        if (tools.isBlockPosSafe(blockPos, world)) {
            return Optional.of(blockPos);
        }
        for (int row = 1; row <= rows; ++row) {
            for (int z = -row; z <= row; ++z) {
                for (int x = -row; x <= row; ++x) {
                    for (int y = -row; y <= row; ++y) {
                        BlockPos newPos;
                        if (x != -row && x != row && z != -row && z != row && y != -row && y != row || !tools.isBlockPosSafe(newPos = new BlockPos(blockPosX + x, blockPosY + y, blockPosZ + z), world)) continue;
                        return Optional.of(newPos);
                    }
                }
            }
        }
        return Optional.empty();
    }

    public static MutableComponent getTranslatedText(String key, ServerPlayer player, MutableComponent ... args) {
        String language = player.clientInformation().language().toLowerCase();
        String regex = "%(\\d+)%";
        Pattern pattern = Pattern.compile(regex);
        try {
            String filePath = String.format("/assets/%s/lang/%s.json", "teleport_commands", language);
            InputStream stream = TeleportCommands.class.getResourceAsStream(filePath);
            InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream, String.format("Couldn't find the required language file for \"%s\"", language)), StandardCharsets.UTF_8);
            JsonElement json = JsonParser.parseReader((Reader)reader);
            String translation = json.getAsJsonObject().get(key).getAsString();
            Matcher matcher = pattern.matcher(Objects.requireNonNull(translation));
            MutableComponent component = Component.literal((String)"");
            int lastIndex = 0;
            while (matcher.find()) {
                component.append((Component)Component.literal((String)translation.substring(lastIndex, matcher.start())));
                int index = Integer.parseInt(matcher.group(1));
                component.append((Component)args[index]);
                lastIndex = matcher.end();
            }
            component.append(translation.substring(lastIndex));
            return component;
        }
        catch (Exception e) {
            try {
                if (!Objects.equals(language, "en_us")) {
                    String filePath = String.format("/assets/%s/lang/en_us.json", "teleport_commands");
                    InputStream stream = TeleportCommands.class.getResourceAsStream(filePath);
                    InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(stream, String.format("Couldn't find the required language file for \"%s\"", language)), StandardCharsets.UTF_8);
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    String translation = json.getAsJsonObject().get(key).getAsString();
                    Matcher matcher = pattern.matcher(Objects.requireNonNull(translation, "translation cannot be null"));
                    MutableComponent component = Component.literal((String)"");
                    int lastIndex = 0;
                    while (matcher.find()) {
                        component.append((Component)Component.literal((String)translation.substring(lastIndex, matcher.start())));
                        int index = Integer.parseInt(matcher.group(1));
                        component.append((Component)args[index]);
                        lastIndex = matcher.end();
                    }
                    component.append(translation.substring(lastIndex));
                    return component;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Constants.LOGGER.error("Key \"{}\" not found in the default language (en_us), sending raw key as fallback.", (Object)key);
            return Component.literal((String)key);
        }
    }

    public static List<String> getWorldIds() {
        return StreamSupport.stream(TeleportCommands.SERVER.getAllLevels().spliterator(), false).map(level -> level.dimension().location().toString()).toList();
    }

    private static boolean isBlockPosSafe(BlockPos bottomPlayer, ServerLevel world) {
        BlockPos belowPlayer = new BlockPos(bottomPlayer.getX(), bottomPlayer.getY() - 1, bottomPlayer.getZ());
        String belowPlayerId = world.getBlockState(belowPlayer).getBlock().getDescriptionId();
        String BottomPlayerId = world.getBlockState(bottomPlayer).getBlock().getDescriptionId();
        BlockPos TopPlayer = new BlockPos(bottomPlayer.getX(), bottomPlayer.getY() + 1, bottomPlayer.getZ());
        String TopPlayerId = world.getBlockState(TopPlayer).getBlock().getDescriptionId();
        return (belowPlayerId.equals("block.minecraft.water") || !world.getBlockState(belowPlayer).getCollisionShape((BlockGetter)world, belowPlayer).isEmpty()) && world.getBlockState(bottomPlayer).getCollisionShape((BlockGetter)world, bottomPlayer).isEmpty() && !unsafeCollisionFreeBlocks.contains(BottomPlayerId) && !unsafeCollisionFreeBlocks.contains(TopPlayerId);
    }
}

