#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    if (color.a < 0.1) {
        discard;
    }
    color *= vertexColor * ColorModulator;
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    color *= lightMapColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
	
	// Emissive
	if (color.a > 0.996 && color.a < 0.997) {
		fragColor = linear_fog(texture(Sampler0, texCoord0), vertexDistance, FogStart, FogEnd, FogColor);
	} else if (color.a > 0.992 && color.a < 0.993) {
		fragColor = linear_fog(texture(Sampler0, texCoord0) * vec4(ColorModulator.rgb * vec3(0.5), 1), vertexDistance, FogStart, FogEnd, FogColor);
	}
}
