/*
 * Decompiled with CFR 0.152.
 */
package net.adswstudios.invalidmodjar.world.features.treedecorators;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.LeaveVineDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class NullcLeaveDecorator
extends LeaveVineDecorator {
    public static MapCodec<NullcLeaveDecorator> CODEC = MapCodec.unit(NullcLeaveDecorator::new);
    public static TreeDecoratorType<?> DECORATOR_TYPE = new TreeDecoratorType(CODEC);

    @SubscribeEvent
    public static void registerTreeDecorator(RegisterEvent event) {
        event.register(Registries.TREE_DECORATOR_TYPE, ResourceLocation.parse((String)"invalid_modjar:nullc_tree_leave_decorator"), () -> DECORATOR_TYPE);
    }

    public NullcLeaveDecorator() {
        super(0.25f);
    }

    protected TreeDecoratorType<?> type() {
        return DECORATOR_TYPE;
    }

    public void place(TreeDecorator.Context context) {
        context.leaves().forEach(blockpos -> {
            BlockPos pos;
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.west())) {
                NullcLeaveDecorator.addVine(pos, Direction.WEST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.east())) {
                NullcLeaveDecorator.addVine(pos, Direction.EAST, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.north())) {
                NullcLeaveDecorator.addVine(pos, Direction.NORTH, context);
            }
            if (context.random().nextFloat() < 0.25f && context.isAir(pos = blockpos.south())) {
                NullcLeaveDecorator.addVine(pos, Direction.SOUTH, context);
            }
        });
    }

    private static void addVine(BlockPos pos, Direction direction, TreeDecorator.Context context) {
        context.setBlock(pos, Blocks.AIR.defaultBlockState());
        BlockPos blockpos = pos.below();
        for (int i = 4; context.isAir(blockpos) && i > 0; --i) {
            context.setBlock(blockpos, NullcLeaveDecorator.oriented(Blocks.AIR.defaultBlockState(), direction));
            blockpos = blockpos.below();
        }
    }

    private static BlockState oriented(BlockState blockstate, Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> blockstate.rotate(Rotation.CLOCKWISE_180);
            case Direction.EAST -> blockstate.rotate(Rotation.CLOCKWISE_90);
            case Direction.WEST -> blockstate.rotate(Rotation.COUNTERCLOCKWISE_90);
            default -> blockstate;
        };
    }
}

