/*
 * Decompiled with CFR 0.152.
 */
package net.adswstudios.invalidmodjar.fluid;

import net.adswstudios.invalidmodjar.init.InvalidModjarModBlocks;
import net.adswstudios.invalidmodjar.init.InvalidModjarModFluidTypes;
import net.adswstudios.invalidmodjar.init.InvalidModjarModFluids;
import net.adswstudios.invalidmodjar.init.InvalidModjarModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class HeavenfluidFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)InvalidModjarModFluidTypes.HEAVENFLUID_TYPE.get(), () -> (Fluid)InvalidModjarModFluids.HEAVENFLUID.get(), () -> (Fluid)InvalidModjarModFluids.FLOWING_HEAVENFLUID.get()).explosionResistance(100.0f).levelDecreasePerBlock(8).bucket(() -> (Item)InvalidModjarModItems.HEAVENFLUID_BUCKET.get()).block(() -> (LiquidBlock)InvalidModjarModBlocks.HEAVENFLUID.get());

    private HeavenfluidFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.FALLING_LAVA;
    }

    public static class Flowing
    extends HeavenfluidFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends HeavenfluidFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

