/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.argument;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.annotation.Flag;
import com.jonahseguin.drink.argument.CommandArg;
import com.jonahseguin.drink.argument.CommandArgs;
import com.jonahseguin.drink.command.CommandExecution;
import com.jonahseguin.drink.command.CommandFlag;
import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandArgumentException;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.parametric.CommandParameter;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ArgumentParser {
    private final DrinkCommandService commandService;

    public ArgumentParser(DrinkCommandService commandService) {
        this.commandService = commandService;
    }

    public List<String> combineMultiWordArguments(List<String> args) {
        ArrayList<String> argList = new ArrayList<String>(args.size());
        for (int i = 0; i < args.size(); ++i) {
            char c;
            String arg = args.get(i);
            if (!(arg.isEmpty() || (c = arg.charAt(0)) != '\"' && c != '\'')) {
                int endIndex;
                StringBuilder builder = new StringBuilder();
                for (endIndex = i; endIndex < args.size(); ++endIndex) {
                    String arg2 = args.get(endIndex);
                    if (arg2.charAt(arg2.length() - 1) == c && arg2.length() > 1) {
                        if (endIndex != i) {
                            builder.append(' ');
                        }
                        builder.append(arg2, endIndex == i ? 1 : 0, arg2.length() - 1);
                        break;
                    }
                    if (endIndex == i) {
                        builder.append(arg2.substring(1));
                        continue;
                    }
                    builder.append(' ').append(arg2);
                }
                if (endIndex < args.size()) {
                    arg = builder.toString();
                    i = endIndex;
                }
            }
            if (arg.isEmpty()) continue;
            argList.add(arg);
        }
        return argList;
    }

    @Nonnull
    public Object[] parseArguments(@Nonnull CommandExecution execution, @Nonnull DrinkCommand command, @Nonnull CommandArgs args) throws CommandExitMessage, CommandArgumentException {
        Preconditions.checkNotNull((Object)command, (Object)"DrinkCommand cannot be null");
        Preconditions.checkNotNull((Object)args, (Object)"CommandArgs cannot be null");
        Object[] arguments = new Object[command.getMethod().getParameterCount()];
        for (int i = 0; i < command.getParameters().getParameters().length; ++i) {
            Object o;
            CommandParameter parameter = command.getParameters().getParameters()[i];
            DrinkProvider<?> provider = command.getProviders()[i];
            String value = null;
            if (parameter.isFlag()) {
                Flag flag = parameter.getFlag();
                CommandFlag commandFlag = args.getFlags().get(Character.valueOf(flag.value()));
                String string = value = commandFlag != null ? commandFlag.getValue() : null;
                if (parameter.isFlag() && value == null && !parameter.getType().isAssignableFrom(Boolean.class) && !parameter.getType().isAssignableFrom(Boolean.TYPE) && !provider.allowNullArgument()) {
                    arguments[i] = provider.defaultNullValue();
                    continue;
                }
                Object o2 = provider.provide(new CommandArg(args.getSender(), value, args), parameter.getAllAnnotations());
                o2 = this.commandService.getModifierService().executeModifiers(execution, parameter, o2);
                arguments[i] = o2;
                continue;
            }
            if (parameter.isOptional() && provider.doesConsumeArgument()) {
                if (args.hasNext()) {
                    value = args.next();
                }
                if (value == null && !provider.allowNullArgument()) {
                    value = parameter.getDefaultOptionalValue();
                    o = provider.provide(new CommandArg(args.getSender(), value, args), parameter.getAllAnnotations());
                    o = this.commandService.getModifierService().executeModifiers(execution, parameter, o);
                    arguments[i] = o;
                    continue;
                }
                try {
                    o = provider.provide(new CommandArg(args.getSender(), value, args), parameter.getAllAnnotations());
                    o = this.commandService.getModifierService().executeModifiers(execution, parameter, o);
                    arguments[i] = o;
                }
                catch (CommandExitMessage ex) {
                    value = parameter.getDefaultOptionalValue();
                    Object o3 = provider.provide(new CommandArg(args.getSender(), value, args), parameter.getAllAnnotations());
                    o3 = this.commandService.getModifierService().executeModifiers(execution, parameter, o3);
                    arguments[i] = o3;
                    args.skip();
                }
                continue;
            }
            if (provider.doesConsumeArgument()) {
                if (!args.hasNext()) {
                    throw new CommandArgumentException("Missing argument for: " + provider.argumentDescription());
                }
                value = args.next();
                if (value == null && !provider.allowNullArgument()) {
                    throw new CommandArgumentException("Argument already consumed for next argument: " + provider.argumentDescription() + " (this is a provider error!)");
                }
            }
            o = provider.provide(new CommandArg(args.getSender(), value, args), parameter.getAllAnnotations());
            o = this.commandService.getModifierService().executeModifiers(execution, parameter, o);
            arguments[i] = o;
        }
        return arguments;
    }
}

