/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.argument;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.command.CommandFlag;
import com.jonahseguin.drink.command.DrinkCommandService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandArgs {
    private final DrinkCommandService commandService;
    private final CommandSender sender;
    private final List<String> args;
    private final String label;
    private final Map<Character, CommandFlag> flags;
    private final ReentrantLock lock = new ReentrantLock();
    private int index = 0;

    public CommandArgs(@Nonnull DrinkCommandService commandService, @Nonnull CommandSender sender, @Nonnull String label, @Nonnull List<String> args, @Nonnull Map<Character, CommandFlag> flags) {
        Preconditions.checkNotNull((Object)commandService, (Object)"CommandService cannot be null");
        Preconditions.checkNotNull((Object)sender, (Object)"CommandSender cannot be null");
        Preconditions.checkNotNull((Object)label, (Object)"Label cannot be null");
        Preconditions.checkNotNull(args, (Object)"Command args cannot be null");
        this.commandService = commandService;
        this.sender = sender;
        this.label = label;
        this.args = new ArrayList<String>(args);
        this.flags = flags;
    }

    public boolean hasNext() {
        this.lock.lock();
        try {
            boolean bl = this.args.size() > this.index;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void skip() {
        this.lock.lock();
        try {
            --this.index;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String next() {
        this.lock.lock();
        try {
            String string = this.args.get(this.index++);
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isSenderPlayer() {
        return this.sender instanceof Player;
    }

    public Player getSenderAsPlayer() {
        return (Player)this.sender;
    }

    @Generated
    public DrinkCommandService getCommandService() {
        return this.commandService;
    }

    @Generated
    public CommandSender getSender() {
        return this.sender;
    }

    @Generated
    public List<String> getArgs() {
        return this.args;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public Map<Character, CommandFlag> getFlags() {
        return this.flags;
    }

    @Generated
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }
}

