/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.jonahseguin.drink.annotation.Command;
import com.jonahseguin.drink.annotation.Require;
import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandRegistrationException;
import com.jonahseguin.drink.exception.CommandStructureException;
import com.jonahseguin.drink.exception.MissingProviderException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CommandExtractor {
    private final DrinkCommandService commandService;

    public CommandExtractor(DrinkCommandService commandService) {
        this.commandService = commandService;
    }

    public Map<String, DrinkCommand> extractCommands(@Nonnull Object handler) throws MissingProviderException, CommandStructureException {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler object cannot be null");
        HashMap<String, DrinkCommand> commands = new HashMap<String, DrinkCommand>();
        for (Method method : handler.getClass().getDeclaredMethods()) {
            Optional<DrinkCommand> o = this.extractCommand(handler, method);
            if (!o.isPresent()) continue;
            DrinkCommand drinkCommand = o.get();
            commands.put(this.commandService.getCommandKey(drinkCommand.getName()), drinkCommand);
        }
        return commands;
    }

    private Optional<DrinkCommand> extractCommand(@Nonnull Object handler, @Nonnull Method method) throws MissingProviderException, CommandStructureException {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler object cannot be null");
        Preconditions.checkNotNull((Object)method, (Object)"Method cannot be null");
        if (method.isAnnotationPresent(Command.class)) {
            try {
                method.setAccessible(true);
            }
            catch (SecurityException ex) {
                throw new CommandRegistrationException("Couldn't access method " + method.getName());
            }
            Command command = method.getAnnotation(Command.class);
            Object perm = "";
            if (method.isAnnotationPresent(Require.class)) {
                require = method.getAnnotation(Require.class);
                perm = require.value();
            } else if (method.getDeclaringClass().isAnnotationPresent(Require.class)) {
                require = method.getDeclaringClass().getAnnotation(Require.class);
                perm = require.value() + (command.name().isEmpty() ? "" : ".") + command.name();
            }
            DrinkCommand drinkCommand = new DrinkCommand(this.commandService, command.name(), Sets.newHashSet((Object[])command.aliases()), command.desc(), command.usage(), command.async(), (String)perm, command.hidden(), handler, method);
            return Optional.of(drinkCommand);
        }
        return Optional.empty();
    }
}

