/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandStructureException;
import com.jonahseguin.drink.exception.MissingProviderException;
import com.jonahseguin.drink.parametric.CommandParameter;
import com.jonahseguin.drink.parametric.CommandParameters;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.lang.reflect.Method;
import java.util.Set;
import lombok.Generated;

public class DrinkCommand {
    private final DrinkCommandService commandService;
    private final String name;
    private final Set<String> allAliases;
    private final Set<String> aliases;
    private final String description;
    private final String usage;
    private final String permission;
    private final Object handler;
    private final Method method;
    private final CommandParameters parameters;
    private final DrinkProvider<?>[] providers;
    private final DrinkProvider<?>[] consumingProviders;
    private final int consumingArgCount;
    private final int requiredArgCount;
    private final boolean requiresAsync;
    private final String generatedUsage;
    private final boolean hidden;

    public DrinkCommand(DrinkCommandService commandService, String name, Set<String> aliases, String description, String usage, boolean async, String permission, boolean hidden, Object handler, Method method) throws MissingProviderException, CommandStructureException {
        this.commandService = commandService;
        this.name = name;
        this.aliases = aliases;
        this.description = description;
        this.usage = usage;
        this.permission = permission;
        this.handler = handler;
        this.method = method;
        this.parameters = new CommandParameters(method);
        this.providers = commandService.getProviderAssigner().assignProvidersFor(this);
        this.consumingArgCount = this.calculateConsumingArgCount();
        this.requiredArgCount = this.calculateRequiredArgCount();
        this.consumingProviders = this.calculateConsumingProviders();
        this.requiresAsync = async || this.calculateRequiresAsync();
        this.generatedUsage = this.generateUsage();
        this.hidden = hidden;
        this.allAliases = aliases;
        if (name.length() > 0 && !name.equals(DrinkCommandService.DEFAULT_KEY)) {
            this.allAliases.add(name);
        }
    }

    public String getMostApplicableUsage() {
        if (this.usage.length() > 0) {
            return this.usage;
        }
        return this.generatedUsage;
    }

    public String getShortDescription() {
        if (this.description.length() > 24) {
            return this.description.substring(0, 21) + "...";
        }
        return this.description;
    }

    private String generateUsage() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.parameters.getParameters().length; ++i) {
            CommandParameter parameter = this.parameters.getParameters()[i];
            DrinkProvider<?> provider = this.providers[i];
            String description = parameter.getParameter().getName();
            if (parameter.isFlag()) {
                sb.append("-").append(parameter.getFlag().value()).append(" ");
                continue;
            }
            if (!provider.doesConsumeArgument()) continue;
            if (parameter.isOptional()) {
                sb.append("[").append(description);
                if (parameter.isText()) {
                    sb.append("...");
                }
                if (parameter.getDefaultOptionalValue() != null && parameter.getDefaultOptionalValue().length() > 0) {
                    sb.append(" = ").append(parameter.getDefaultOptionalValue());
                }
                sb.append("]");
            } else {
                sb.append("<").append(description);
                if (parameter.isText()) {
                    sb.append("...");
                }
                sb.append(">");
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    private boolean calculateRequiresAsync() {
        for (DrinkProvider<?> provider : this.providers) {
            if (!provider.isAsync()) continue;
            return true;
        }
        return false;
    }

    private DrinkProvider<?>[] calculateConsumingProviders() {
        DrinkProvider[] consumingProviders = new DrinkProvider[this.consumingArgCount];
        int x = 0;
        for (DrinkProvider<?> provider : this.providers) {
            if (!provider.doesConsumeArgument()) continue;
            consumingProviders[x] = provider;
            ++x;
        }
        return consumingProviders;
    }

    private int calculateConsumingArgCount() {
        int count = 0;
        for (DrinkProvider<?> provider : this.providers) {
            if (!provider.doesConsumeArgument()) continue;
            ++count;
        }
        return count;
    }

    private int calculateRequiredArgCount() {
        int count = 0;
        for (int i = 0; i < this.parameters.getParameters().length; ++i) {
            DrinkProvider<?> provider;
            CommandParameter parameter = this.parameters.getParameters()[i];
            if (parameter.isFlag() || parameter.isOptional() || !(provider = this.providers[i]).doesConsumeArgument()) continue;
            ++count;
        }
        return count;
    }

    @Generated
    public DrinkCommandService getCommandService() {
        return this.commandService;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<String> getAllAliases() {
        return this.allAliases;
    }

    @Generated
    public Set<String> getAliases() {
        return this.aliases;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public Object getHandler() {
        return this.handler;
    }

    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public CommandParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public DrinkProvider<?>[] getProviders() {
        return this.providers;
    }

    @Generated
    public DrinkProvider<?>[] getConsumingProviders() {
        return this.consumingProviders;
    }

    @Generated
    public int getConsumingArgCount() {
        return this.consumingArgCount;
    }

    @Generated
    public int getRequiredArgCount() {
        return this.requiredArgCount;
    }

    @Generated
    public boolean isRequiresAsync() {
        return this.requiresAsync;
    }

    @Generated
    public String getGeneratedUsage() {
        return this.generatedUsage;
    }

    @Generated
    public boolean isHidden() {
        return this.hidden;
    }
}

