/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandExecutor;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.command.DrinkTabCompleter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;

public class DrinkCommandContainer
extends Command
implements PluginIdentifiableCommand {
    private final DrinkCommandService commandService;
    private final Object object;
    private final String name;
    private final Set<String> aliases;
    private final Map<String, DrinkCommand> commands;
    private final DrinkCommand defaultCommand;
    private final DrinkCommandExecutor executor;
    private final DrinkTabCompleter tabCompleter;
    private boolean overrideExistingCommands = true;
    private boolean defaultCommandIsHelp = false;

    public DrinkCommandContainer(DrinkCommandService commandService, Object object, String name, Set<String> aliases, Map<String, DrinkCommand> commands) {
        super(name, "", "/" + name, new ArrayList<String>(aliases));
        this.commandService = commandService;
        this.object = object;
        this.name = name;
        this.aliases = aliases;
        this.commands = commands;
        this.defaultCommand = this.calculateDefaultCommand();
        this.executor = new DrinkCommandExecutor(commandService, this);
        this.tabCompleter = new DrinkTabCompleter(commandService, this);
        if (this.defaultCommand != null) {
            this.setUsage("/" + name + " " + this.defaultCommand.getGeneratedUsage());
            this.setDescription(this.defaultCommand.getDescription());
            this.setPermission(this.defaultCommand.getPermission());
        }
    }

    public final DrinkCommandContainer registerSub(@Nonnull Object handler) {
        return this.commandService.registerSub(this, handler);
    }

    public List<String> getCommandSuggestions(@Nonnull String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        String p = prefix.toLowerCase();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (DrinkCommand c : this.commands.values()) {
            if (c.isHidden()) continue;
            for (String alias : c.getAllAliases()) {
                if (alias.length() <= 0 || p.length() != 0 && !alias.toLowerCase().startsWith(p)) continue;
                suggestions.add(alias);
            }
        }
        return suggestions;
    }

    private DrinkCommand calculateDefaultCommand() {
        for (DrinkCommand dc : this.commands.values()) {
            if (dc.getName().length() != 0 && !dc.getName().equals(DrinkCommandService.DEFAULT_KEY)) continue;
            return dc;
        }
        return null;
    }

    @Nullable
    public DrinkCommand get(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return this.commands.get(this.commandService.getCommandKey(name));
    }

    @Nullable
    public DrinkCommand getByKeyOrAlias(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        if (this.commands.containsKey(key)) {
            return this.commands.get(key);
        }
        for (DrinkCommand drinkCommand : this.commands.values()) {
            if (!drinkCommand.getAliases().contains(key)) continue;
            return drinkCommand;
        }
        return null;
    }

    @Nullable
    public Map.Entry<DrinkCommand, String[]> getCommand(String[] args) {
        for (int i = args.length - 1; i >= 0; --i) {
            String key = this.commandService.getCommandKey(StringUtils.join(Arrays.asList(Arrays.copyOfRange(args, 0, i + 1)), (char)' '));
            DrinkCommand drinkCommand = this.getByKeyOrAlias(key);
            if (drinkCommand == null) continue;
            return new AbstractMap.SimpleEntry<DrinkCommand, String[]>(drinkCommand, Arrays.copyOfRange(args, i + 1, args.length));
        }
        return new AbstractMap.SimpleEntry<DrinkCommand, String[]>(this.getDefaultCommand(), args);
    }

    @Nullable
    public DrinkCommand getDefaultCommand() {
        return this.defaultCommand;
    }

    public boolean execute(CommandSender commandSender, String s, String[] strings) {
        return this.executor.onCommand(commandSender, this, s, strings);
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return this.tabCompleter.onTabComplete(sender, this, alias, args);
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args, Location location) throws IllegalArgumentException {
        return this.tabCompleter.onTabComplete(sender, this, alias, args);
    }

    public Plugin getPlugin() {
        return this.commandService.getPlugin();
    }

    public DrinkCommandService getCommandService() {
        return this.commandService;
    }

    public Object getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getDrinkAliases() {
        return this.aliases;
    }

    public Map<String, DrinkCommand> getCommands() {
        return this.commands;
    }

    public DrinkCommandExecutor getExecutor() {
        return this.executor;
    }

    public DrinkTabCompleter getTabCompleter() {
        return this.tabCompleter;
    }

    public boolean isOverrideExistingCommands() {
        return this.overrideExistingCommands;
    }

    public DrinkCommandContainer setOverrideExistingCommands(boolean overrideExistingCommands) {
        this.overrideExistingCommands = overrideExistingCommands;
        return this;
    }

    public boolean isDefaultCommandIsHelp() {
        return this.defaultCommandIsHelp;
    }

    public DrinkCommandContainer setDefaultCommandIsHelp(boolean defaultCommandIsHelp) {
        this.defaultCommandIsHelp = defaultCommandIsHelp;
        return this;
    }
}

