/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandContainer;
import com.jonahseguin.drink.command.DrinkCommandService;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class DrinkCommandExecutor
implements CommandExecutor {
    private final DrinkCommandService commandService;
    private final DrinkCommandContainer container;

    public DrinkCommandExecutor(DrinkCommandService commandService, DrinkCommandContainer container) {
        this.commandService = commandService;
        this.container = container;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase(this.container.getName())) {
            try {
                Map.Entry<DrinkCommand, String[]> data = this.container.getCommand(args);
                if (data != null && data.getKey() != null) {
                    if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("help") && !data.getKey().getName().equalsIgnoreCase("help")) {
                        this.commandService.getHelpService().sendHelpFor(sender, this.container);
                        return true;
                    }
                    this.commandService.executeCommand(sender, data.getKey(), label, data.getValue());
                } else if (args.length > 0) {
                    if (args[args.length - 1].equalsIgnoreCase("help")) {
                        this.commandService.getHelpService().sendHelpFor(sender, this.container);
                        return true;
                    }
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown sub-command: " + args[0] + ".  Use '/" + label + " help' for available commands.");
                } else if (this.container.isDefaultCommandIsHelp()) {
                    this.commandService.getHelpService().sendHelpFor(sender, this.container);
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Please choose a sub-command.  Use '/" + label + " help' for available commands.");
                }
                return true;
            }
            catch (Exception ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "An exception occurred while performing this command.");
                ex.printStackTrace();
            }
        }
        return false;
    }
}

