/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.CommandService;
import com.jonahseguin.drink.annotation.Duration;
import com.jonahseguin.drink.annotation.Sender;
import com.jonahseguin.drink.annotation.Text;
import com.jonahseguin.drink.argument.ArgumentParser;
import com.jonahseguin.drink.argument.CommandArgs;
import com.jonahseguin.drink.command.CommandExecution;
import com.jonahseguin.drink.command.CommandExtractor;
import com.jonahseguin.drink.command.CommandFlag;
import com.jonahseguin.drink.command.DrinkAuthorizer;
import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandContainer;
import com.jonahseguin.drink.command.DrinkHelpService;
import com.jonahseguin.drink.command.DrinkSpigotRegistry;
import com.jonahseguin.drink.command.FlagExtractor;
import com.jonahseguin.drink.exception.CommandArgumentException;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.exception.CommandRegistrationException;
import com.jonahseguin.drink.exception.CommandStructureException;
import com.jonahseguin.drink.exception.DrinkException;
import com.jonahseguin.drink.exception.MissingProviderException;
import com.jonahseguin.drink.modifier.DrinkModifier;
import com.jonahseguin.drink.modifier.ModifierService;
import com.jonahseguin.drink.parametric.BindingContainer;
import com.jonahseguin.drink.parametric.DrinkBinding;
import com.jonahseguin.drink.parametric.DrinkProvider;
import com.jonahseguin.drink.parametric.ProviderAssigner;
import com.jonahseguin.drink.parametric.binder.DrinkBinder;
import com.jonahseguin.drink.provider.BooleanProvider;
import com.jonahseguin.drink.provider.CommandArgsProvider;
import com.jonahseguin.drink.provider.DateProvider;
import com.jonahseguin.drink.provider.DoubleProvider;
import com.jonahseguin.drink.provider.DurationProvider;
import com.jonahseguin.drink.provider.IntegerProvider;
import com.jonahseguin.drink.provider.LongProvider;
import com.jonahseguin.drink.provider.StringProvider;
import com.jonahseguin.drink.provider.TextProvider;
import com.jonahseguin.drink.provider.spigot.CommandSenderProvider;
import com.jonahseguin.drink.provider.spigot.ConsoleCommandSenderProvider;
import com.jonahseguin.drink.provider.spigot.PlayerProvider;
import com.jonahseguin.drink.provider.spigot.PlayerSenderProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DrinkCommandService
implements CommandService {
    public static String DEFAULT_KEY = "DRINK_DEFAULT";
    private final JavaPlugin plugin;
    private final CommandExtractor extractor;
    private final DrinkHelpService helpService;
    private final ProviderAssigner providerAssigner;
    private final ArgumentParser argumentParser;
    private final ModifierService modifierService;
    private final DrinkSpigotRegistry spigotRegistry;
    private final FlagExtractor flagExtractor;
    private final ConcurrentMap<String, DrinkCommandContainer> commands = new ConcurrentHashMap<String, DrinkCommandContainer>();
    private final ConcurrentMap<Class<?>, BindingContainer<?>> bindings = new ConcurrentHashMap();
    private DrinkAuthorizer authorizer;

    public DrinkCommandService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.extractor = new CommandExtractor(this);
        this.helpService = new DrinkHelpService(this);
        this.providerAssigner = new ProviderAssigner(this);
        this.argumentParser = new ArgumentParser(this);
        this.modifierService = new ModifierService(this);
        this.spigotRegistry = new DrinkSpigotRegistry(this);
        this.flagExtractor = new FlagExtractor(this);
        this.authorizer = new DrinkAuthorizer();
        this.bindDefaults();
    }

    private void bindDefaults() {
        this.bind(Boolean.class).toProvider(BooleanProvider.INSTANCE);
        this.bind(Boolean.TYPE).toProvider(BooleanProvider.INSTANCE);
        this.bind(Double.class).toProvider(DoubleProvider.INSTANCE);
        this.bind(Double.TYPE).toProvider(DoubleProvider.INSTANCE);
        this.bind(Integer.class).toProvider(IntegerProvider.INSTANCE);
        this.bind(Integer.TYPE).toProvider(IntegerProvider.INSTANCE);
        this.bind(Long.class).toProvider(LongProvider.INSTANCE);
        this.bind(Long.TYPE).toProvider(LongProvider.INSTANCE);
        this.bind(String.class).toProvider(StringProvider.INSTANCE);
        this.bind(String.class).annotatedWith(Text.class).toProvider(TextProvider.INSTANCE);
        this.bind(Date.class).toProvider(DateProvider.INSTANCE);
        this.bind(Date.class).annotatedWith(Duration.class).toProvider(DurationProvider.INSTANCE);
        this.bind(CommandArgs.class).toProvider(CommandArgsProvider.INSTANCE);
        this.bind(CommandSender.class).annotatedWith(Sender.class).toProvider(CommandSenderProvider.INSTANCE);
        this.bind(ConsoleCommandSender.class).annotatedWith(Sender.class).toProvider(ConsoleCommandSenderProvider.INSTANCE);
        this.bind(Player.class).annotatedWith(Sender.class).toProvider(PlayerSenderProvider.INSTANCE);
        this.bind(Player.class).toProvider(new PlayerProvider((Plugin)this.plugin));
    }

    @Override
    public void setAuthorizer(@Nonnull DrinkAuthorizer authorizer) {
        Preconditions.checkNotNull((Object)authorizer, (Object)"Authorizer cannot be null");
        this.authorizer = authorizer;
    }

    @Override
    public void registerCommands() {
        this.commands.values().forEach(cmd -> this.spigotRegistry.register((DrinkCommandContainer)((Object)cmd), cmd.isOverrideExistingCommands()));
    }

    @Override
    public DrinkCommandContainer register(@Nonnull Object handler, @Nonnull String name, String ... aliases) throws CommandRegistrationException {
        Preconditions.checkNotNull((Object)handler, (Object)"Handler object cannot be null");
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        Preconditions.checkState((name.length() > 0 ? 1 : 0) != 0, (Object)"Name cannot be empty (must be > 0 characters in length)");
        HashSet<String> aliasesSet = new HashSet<String>();
        if (aliases != null) {
            aliasesSet.addAll(Arrays.asList(aliases));
            aliasesSet.removeIf(s -> s.length() == 0);
        }
        try {
            Map<String, DrinkCommand> extractCommands = this.extractor.extractCommands(handler);
            if (extractCommands.isEmpty()) {
                throw new CommandRegistrationException("There were no commands to register in the " + handler.getClass().getSimpleName() + " class (" + extractCommands.size() + ")");
            }
            DrinkCommandContainer container = new DrinkCommandContainer(this, handler, name, aliasesSet, extractCommands);
            this.commands.put(this.getCommandKey(name), container);
            return container;
        }
        catch (CommandStructureException | MissingProviderException ex) {
            throw new CommandRegistrationException("Could not register command '" + name + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public DrinkCommandContainer registerSub(@Nonnull DrinkCommandContainer root, @Nonnull Object handler) {
        Preconditions.checkNotNull((Object)((Object)root), (Object)"Root command container cannot be null");
        Preconditions.checkNotNull((Object)handler, (Object)"Handler object cannot be null");
        try {
            Map<String, DrinkCommand> extractCommands = this.extractor.extractCommands(handler);
            extractCommands.forEach((s, d) -> root.getCommands().put((String)s, (DrinkCommand)d));
            return root;
        }
        catch (CommandStructureException | MissingProviderException ex) {
            throw new CommandRegistrationException("Could not register sub-command in root '" + String.valueOf((Object)root) + "' with handler '" + handler.getClass().getSimpleName() + "': " + ex.getMessage(), ex);
        }
    }

    @Override
    public <T> void registerModifier(@Nonnull Class<? extends Annotation> annotation, @Nonnull Class<T> type, @Nonnull DrinkModifier<T> modifier) {
        this.modifierService.registerModifier(annotation, type, modifier);
    }

    void executeCommand(@Nonnull CommandSender sender, @Nonnull DrinkCommand command, @Nonnull String label, @Nonnull String[] args) {
        Preconditions.checkNotNull((Object)sender, (Object)"Sender cannot be null");
        Preconditions.checkNotNull((Object)command, (Object)"Command cannot be null");
        Preconditions.checkNotNull((Object)label, (Object)"Label cannot be null");
        Preconditions.checkNotNull((Object)args, (Object)"Args cannot be null");
        if (this.authorizer.isAuthorized(sender, command)) {
            if (command.isRequiresAsync()) {
                this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> this.finishExecution(sender, command, label, args));
            } else {
                this.finishExecution(sender, command, label, args);
            }
        }
    }

    private void finishExecution(@Nonnull CommandSender sender, @Nonnull DrinkCommand command, @Nonnull String label, @Nonnull String[] args) {
        List<String> argList = new ArrayList<String>(Arrays.asList(args));
        try {
            argList = this.argumentParser.combineMultiWordArguments(argList);
            Map<Character, CommandFlag> flags = this.flagExtractor.extractFlags(argList);
            CommandArgs commandArgs = new CommandArgs(this, sender, label, argList, flags);
            CommandExecution execution = new CommandExecution(this, sender, argList, commandArgs, command);
            Object[] parsedArguments = this.argumentParser.parseArguments(execution, command, commandArgs);
            if (!execution.isCanExecute()) {
                return;
            }
            try {
                command.getMethod().invoke(command.getHandler(), parsedArguments);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not perform command.  Notify an administrator");
                throw new DrinkException("Failed to execute command '" + command.getName() + "' with arguments '" + StringUtils.join(Arrays.asList(args), (char)' ') + " for sender " + sender.getName(), ex);
            }
        }
        catch (CommandExitMessage ex) {
            ex.print(sender);
        }
        catch (CommandArgumentException ex) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + ex.getMessage());
            this.helpService.sendUsageMessage(sender, this.getContainerFor(command), command);
        }
    }

    @Nullable
    public DrinkCommandContainer getContainerFor(@Nonnull DrinkCommand command) {
        Preconditions.checkNotNull((Object)command, (Object)"DrinkCommand cannot be null");
        for (DrinkCommandContainer container : this.commands.values()) {
            if (!container.getCommands().containsValue(command)) continue;
            return container;
        }
        return null;
    }

    @Nullable
    public <T> BindingContainer<T> getBindingsFor(@Nonnull Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"Type cannot be null");
        if (this.bindings.containsKey(type)) {
            return (BindingContainer)this.bindings.get(type);
        }
        return null;
    }

    @Override
    @Nullable
    public DrinkCommandContainer get(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        return (DrinkCommandContainer)((Object)this.commands.get(this.getCommandKey(name)));
    }

    public String getCommandKey(@Nonnull String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
        if (name.length() == 0) {
            return DEFAULT_KEY;
        }
        return name.toLowerCase();
    }

    @Override
    public <T> DrinkBinder<T> bind(@Nonnull Class<T> type) {
        Preconditions.checkNotNull(type, (Object)"Type cannot be null for bind");
        return new DrinkBinder<T>(this, type);
    }

    public <T> void bindProvider(@Nonnull Class<T> type, @Nonnull Set<Class<? extends Annotation>> annotations, @Nonnull DrinkProvider<T> provider) {
        Preconditions.checkNotNull(type, (Object)"Type cannot be null");
        Preconditions.checkNotNull(annotations, (Object)"Annotations cannot be null");
        Preconditions.checkNotNull(provider, (Object)"Provider cannot be null");
        BindingContainer<T> container = this.getBindingsFor(type);
        if (container == null) {
            container = new BindingContainer<T>(type);
            this.bindings.put(type, container);
        }
        DrinkBinding<T> binding = new DrinkBinding<T>(type, annotations, provider);
        container.getBindings().add(binding);
    }

    @Generated
    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public CommandExtractor getExtractor() {
        return this.extractor;
    }

    @Generated
    public DrinkHelpService getHelpService() {
        return this.helpService;
    }

    @Generated
    public ProviderAssigner getProviderAssigner() {
        return this.providerAssigner;
    }

    @Generated
    public ArgumentParser getArgumentParser() {
        return this.argumentParser;
    }

    @Generated
    public ModifierService getModifierService() {
        return this.modifierService;
    }

    @Generated
    public DrinkSpigotRegistry getSpigotRegistry() {
        return this.spigotRegistry;
    }

    @Generated
    public FlagExtractor getFlagExtractor() {
        return this.flagExtractor;
    }

    @Generated
    public ConcurrentMap<String, DrinkCommandContainer> getCommands() {
        return this.commands;
    }

    @Generated
    public ConcurrentMap<Class<?>, BindingContainer<?>> getBindings() {
        return this.bindings;
    }

    @Generated
    public DrinkAuthorizer getAuthorizer() {
        return this.authorizer;
    }
}

