/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandContainer;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.command.HelpFormatter;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class DrinkHelpService {
    private final DrinkCommandService commandService;
    private HelpFormatter helpFormatter;

    public DrinkHelpService(DrinkCommandService commandService) {
        this.commandService = commandService;
        this.helpFormatter = (sender, container) -> {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7&m--------------------------------"));
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&bHelp &7- &6/" + container.getName())));
            for (DrinkCommand c : container.getCommands().values()) {
                TextComponent msg = new TextComponent(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)("&7/" + container.getName() + (String)(c.getName().length() > 0 ? " &e" + c.getName() : "") + " &7" + c.getMostApplicableUsage() + " &7- &f" + c.getShortDescription())));
                msg.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)(String.valueOf(ChatColor.GRAY) + "/" + container.getName() + " " + c.getName() + " - " + String.valueOf(ChatColor.WHITE) + c.getDescription()))));
                msg.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + container.getName() + " " + c.getName()));
                sender.spigot().sendMessage((BaseComponent)msg);
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7&m--------------------------------"));
        };
    }

    public void sendHelpFor(CommandSender sender, DrinkCommandContainer container) {
        this.helpFormatter.sendHelpFor(sender, container);
    }

    public void sendUsageMessage(CommandSender sender, DrinkCommandContainer container, DrinkCommand command) {
        sender.sendMessage(this.getUsageMessage(container, command));
    }

    public String getUsageMessage(DrinkCommandContainer container, DrinkCommand command) {
        String usage = String.valueOf(ChatColor.RED) + "Command Usage: /" + container.getName() + " ";
        if (command.getName().length() > 0) {
            usage = usage + command.getName() + " ";
        }
        usage = command.getUsage() != null && command.getUsage().length() > 0 ? usage + command.getUsage() : usage + command.getGeneratedUsage();
        return usage;
    }

    @Generated
    public DrinkCommandService getCommandService() {
        return this.commandService;
    }

    @Generated
    public HelpFormatter getHelpFormatter() {
        return this.helpFormatter;
    }

    @Generated
    public void setHelpFormatter(HelpFormatter helpFormatter) {
        this.helpFormatter = helpFormatter;
    }
}

