/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.jonahseguin.drink.command.DrinkCommandContainer;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandRegistrationException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;

public class DrinkSpigotRegistry {
    private final DrinkCommandService commandService;
    private CommandMap commandMap;

    public DrinkSpigotRegistry(DrinkCommandService commandService) {
        this.commandService = commandService;
        try {
            this.commandMap = (CommandMap)this.getPrivateField(Bukkit.getServer(), "commandMap", false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private Map<String, Command> getKnownCommands() throws NoSuchFieldException, IllegalAccessException {
        Object map = this.getPrivateField(this.commandMap, "knownCommands", true);
        HashMap knownCommands = (HashMap)map;
        return knownCommands;
    }

    private Object getPrivateField(Object object, String field, boolean fallback) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field objectField;
        Class<?> clazz = object.getClass();
        try {
            objectField = clazz.getDeclaredField(field);
        }
        catch (NoSuchFieldException e) {
            if (fallback) {
                objectField = clazz.getSuperclass().getDeclaredField(field);
            }
            throw new NoSuchFieldException(e.getMessage());
        }
        objectField.setAccessible(true);
        Object result = objectField.get(object);
        objectField.setAccessible(false);
        return result;
    }

    public boolean register(@Nonnull DrinkCommandContainer container, boolean unregisterExisting) throws CommandRegistrationException {
        if (unregisterExisting) {
            try {
                Map<String, Command> knownCommands = this.getKnownCommands();
                if (knownCommands.containsKey(container.getName().toLowerCase())) {
                    knownCommands.remove(container.getName().toLowerCase()).unregister(this.commandMap);
                }
                for (String s : container.getDrinkAliases()) {
                    if (!knownCommands.containsKey(s.toLowerCase())) continue;
                    knownCommands.remove(s).unregister(this.commandMap);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new CommandRegistrationException("Couldn't access knownCommands field in Bukkit CommandMap to unregister existing command(s)");
            }
        }
        return this.commandMap.register(container.getCommandService().getPlugin().getName(), (Command)container);
    }
}

