/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandContainer;
import com.jonahseguin.drink.command.DrinkCommandService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class DrinkTabCompleter
implements TabCompleter {
    private final DrinkCommandService commandService;
    private final DrinkCommandContainer container;

    public DrinkTabCompleter(DrinkCommandService commandService, DrinkCommandContainer container) {
        this.commandService = commandService;
        this.container = container;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase(this.container.getName())) {
            Map.Entry<DrinkCommand, String[]> data = this.container.getCommand(args);
            if (data != null && data.getKey() != null) {
                DrinkCommand drinkCommand;
                String tabCompleting = "";
                int tabCompletingIndex = 0;
                if (data.getValue().length > 0) {
                    tabCompleting = data.getValue()[data.getValue().length - 1];
                    tabCompletingIndex = data.getValue().length - 1;
                }
                if ((drinkCommand = data.getKey()).getConsumingProviders().length > tabCompletingIndex) {
                    List<String> s = drinkCommand.getConsumingProviders()[tabCompletingIndex].getSuggestions(sender, tabCompleting);
                    if (s != null) {
                        ArrayList<String> suggestions = new ArrayList<String>(s);
                        if (args.length == 0 || args.length == 1) {
                            String tC = "";
                            if (args.length > 0) {
                                tC = args[args.length - 1];
                            }
                            suggestions.addAll(this.container.getCommandSuggestions(tC));
                        }
                        return suggestions;
                    }
                    if (args.length == 0 || args.length == 1) {
                        String tC = "";
                        if (args.length > 0) {
                            tC = args[args.length - 1];
                        }
                        return this.container.getCommandSuggestions(tC);
                    }
                } else if (args.length == 0 || args.length == 1) {
                    String tC = "";
                    if (args.length > 0) {
                        tC = args[args.length - 1];
                    }
                    return this.container.getCommandSuggestions(tC);
                }
            } else if (args.length == 0 || args.length == 1) {
                String tC = "";
                if (args.length > 0) {
                    tC = args[args.length - 1];
                }
                return this.container.getCommandSuggestions(tC);
            }
        }
        return Collections.emptyList();
    }
}

