/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.command;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.command.CommandFlag;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandArgumentException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class FlagExtractor {
    private final DrinkCommandService commandService;

    public FlagExtractor(DrinkCommandService commandService) {
        this.commandService = commandService;
    }

    public Map<Character, CommandFlag> extractFlags(@Nonnull List<String> args) throws CommandArgumentException {
        Preconditions.checkNotNull(args, (Object)"Args cannot be null");
        HashMap<Character, CommandFlag> flags = new HashMap<Character, CommandFlag>();
        Iterator<String> it = args.iterator();
        Character currentFlag = null;
        while (it.hasNext()) {
            String arg = it.next();
            if (currentFlag != null) {
                if (!this.isFlag(arg)) {
                    flags.put(currentFlag, new CommandFlag(currentFlag.charValue(), arg));
                } else {
                    flags.put(currentFlag, new CommandFlag(currentFlag.charValue(), "true"));
                }
                it.remove();
                currentFlag = null;
                continue;
            }
            if (!this.isFlag(arg)) continue;
            char f = this.getFlag(arg);
            if (!flags.containsKey(Character.valueOf(f))) {
                currentFlag = Character.valueOf(f);
                if (!it.hasNext()) {
                    flags.put(currentFlag, new CommandFlag(currentFlag.charValue(), "true"));
                    currentFlag = null;
                }
            } else {
                throw new CommandArgumentException("The flag '-" + f + "' has already been provided in this command.");
            }
            it.remove();
        }
        return flags;
    }

    public char getFlag(@Nonnull String arg) {
        return arg.charAt(1);
    }

    public boolean isFlag(@Nonnull String arg) {
        return arg.length() == 2 && arg.charAt(0) == '-';
    }
}

