/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.modifier;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.annotation.Classifier;
import com.jonahseguin.drink.annotation.Modifier;
import com.jonahseguin.drink.command.CommandExecution;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.modifier.DrinkModifier;
import com.jonahseguin.drink.modifier.ModifierContainer;
import com.jonahseguin.drink.parametric.CommandParameter;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ModifierService {
    private final DrinkCommandService commandService;
    private final ConcurrentMap<Class<? extends Annotation>, ModifierContainer> modifiers = new ConcurrentHashMap<Class<? extends Annotation>, ModifierContainer>();

    public ModifierService(DrinkCommandService commandService) {
        this.commandService = commandService;
    }

    @Nullable
    public Object executeModifiers(@Nonnull CommandExecution execution, @Nonnull CommandParameter param, @Nullable Object parsedArgument) throws CommandExitMessage {
        Preconditions.checkNotNull((Object)execution, (Object)"CommandExecution cannot be null");
        Preconditions.checkNotNull((Object)param, (Object)"CommandParameter cannot be null");
        for (Annotation annotation : param.getModifierAnnotations()) {
            ModifierContainer container = this.getModifiers(annotation.annotationType());
            if (container == null) continue;
            for (DrinkModifier<?> modifier : Objects.requireNonNull(container.getModifiersFor(param.getType()))) {
                parsedArgument = modifier.modify(execution, param, parsedArgument);
            }
        }
        return parsedArgument;
    }

    public <T> void registerModifier(@Nonnull Class<? extends Annotation> annotation, @Nonnull Class<T> type, @Nonnull DrinkModifier<T> modifier) {
        Preconditions.checkNotNull(annotation, (Object)"Annotation cannot be null");
        Preconditions.checkNotNull(type, (Object)"Type cannot be null");
        Preconditions.checkNotNull(modifier, (Object)"Modifier cannot be null");
        this.modifiers.computeIfAbsent(annotation, a -> new ModifierContainer()).getModifiers().computeIfAbsent(type, t -> new HashSet()).add(modifier);
    }

    @Nullable
    public ModifierContainer getModifiers(@Nonnull Class<? extends Annotation> annotation) {
        Preconditions.checkNotNull(annotation, (Object)"Annotation cannot be null");
        Preconditions.checkState((boolean)this.isModifier(annotation), (Object)("Annotation provided is not a modifier (annotate with @Modifier) for getModifier: " + annotation.getSimpleName()));
        Preconditions.checkState((!this.isClassifier(annotation) ? 1 : 0) != 0, (Object)("Annotation provided cannot be an @Classifier and an @Modifier: " + annotation.getSimpleName()));
        if (this.modifiers.containsKey(annotation)) {
            return (ModifierContainer)this.modifiers.get(annotation);
        }
        return null;
    }

    public boolean isModifier(@Nonnull Class<? extends Annotation> type) {
        return type.isAnnotationPresent(Modifier.class);
    }

    public boolean isClassifier(@Nonnull Class<? extends Annotation> type) {
        return type.isAnnotationPresent(Classifier.class);
    }
}

