/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.parametric;

import com.google.common.collect.ImmutableList;
import com.jonahseguin.drink.annotation.Classifier;
import com.jonahseguin.drink.annotation.Flag;
import com.jonahseguin.drink.annotation.LastArg;
import com.jonahseguin.drink.annotation.Modifier;
import com.jonahseguin.drink.annotation.OptArg;
import com.jonahseguin.drink.annotation.Text;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class CommandParameter {
    private final Class<?> type;
    private final Parameter parameter;
    private final List<Annotation> allAnnotations;
    private final List<Annotation> classifierAnnotations;
    private final List<Annotation> modifierAnnotations;
    private final boolean flag;
    private final boolean requireLastArg;

    public CommandParameter(Class<?> type, Parameter parameter, Annotation[] allAnnotations) {
        this.type = type;
        this.parameter = parameter;
        this.allAnnotations = ImmutableList.copyOf((Object[])allAnnotations);
        this.classifierAnnotations = this.loadClassifiers();
        this.modifierAnnotations = this.loadModifiers();
        this.flag = this.loadFlag();
        this.requireLastArg = this.calculateRequireLastArg();
    }

    private boolean calculateRequireLastArg() {
        for (Annotation annotation : this.allAnnotations) {
            if (!annotation.annotationType().isAnnotationPresent(LastArg.class)) continue;
            return true;
        }
        return false;
    }

    public boolean isText() {
        return this.parameter.isAnnotationPresent(Text.class);
    }

    public boolean isOptional() {
        return this.parameter.isAnnotationPresent(OptArg.class);
    }

    public String getDefaultOptionalValue() {
        return this.parameter.getAnnotation(OptArg.class).value();
    }

    private boolean loadFlag() {
        return this.parameter.isAnnotationPresent(Flag.class);
    }

    public boolean isFlag() {
        return this.flag;
    }

    public Flag getFlag() {
        return this.parameter.getAnnotation(Flag.class);
    }

    private List<Annotation> loadClassifiers() {
        ArrayList<Annotation> classifiers = new ArrayList<Annotation>();
        for (Annotation annotation : this.allAnnotations) {
            if (!annotation.annotationType().isAnnotationPresent(Classifier.class)) continue;
            classifiers.add(annotation);
        }
        return ImmutableList.copyOf(classifiers);
    }

    private List<Annotation> loadModifiers() {
        ArrayList<Annotation> modifiers = new ArrayList<Annotation>();
        for (Annotation annotation : this.allAnnotations) {
            if (!annotation.annotationType().isAnnotationPresent(Modifier.class)) continue;
            modifiers.add(annotation);
        }
        return ImmutableList.copyOf(modifiers);
    }

    @Generated
    public Class<?> getType() {
        return this.type;
    }

    @Generated
    public Parameter getParameter() {
        return this.parameter;
    }

    @Generated
    public List<Annotation> getAllAnnotations() {
        return this.allAnnotations;
    }

    @Generated
    public List<Annotation> getClassifierAnnotations() {
        return this.classifierAnnotations;
    }

    @Generated
    public List<Annotation> getModifierAnnotations() {
        return this.modifierAnnotations;
    }

    @Generated
    public boolean isRequireLastArg() {
        return this.requireLastArg;
    }
}

