/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.parametric;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.parametric.CommandParameter;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;

public class DrinkBinding<T> {
    private final Class<T> type;
    private final Set<Class<? extends Annotation>> annotations;
    private final DrinkProvider<T> provider;

    public DrinkBinding(Class<T> type, Set<Class<? extends Annotation>> annotations, DrinkProvider<T> provider) {
        this.type = type;
        this.annotations = annotations;
        this.provider = provider;
    }

    public boolean canProvideFor(@Nonnull CommandParameter parameter) {
        Preconditions.checkNotNull((Object)parameter, (Object)"Parameter cannot be null");
        for (Annotation annotation : parameter.getClassifierAnnotations()) {
            if (this.annotations.contains(annotation.annotationType())) continue;
            return false;
        }
        for (Class clazz : this.annotations) {
            if (!parameter.getClassifierAnnotations().stream().noneMatch(a -> a.annotationType().equals(annotation))) continue;
            return false;
        }
        return true;
    }

    @Generated
    public Class<T> getType() {
        return this.type;
    }

    @Generated
    public Set<Class<? extends Annotation>> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public DrinkProvider<T> getProvider() {
        return this.provider;
    }
}

