/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.parametric;

import com.jonahseguin.drink.argument.CommandArg;
import com.jonahseguin.drink.exception.CommandExitMessage;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.command.CommandSender;

public abstract class DrinkProvider<T> {
    public abstract boolean doesConsumeArgument();

    public abstract boolean isAsync();

    public boolean allowNullArgument() {
        return true;
    }

    @Nullable
    public T defaultNullValue() {
        return null;
    }

    @Nullable
    public abstract T provide(@Nonnull CommandArg var1, @Nonnull List<? extends Annotation> var2) throws CommandExitMessage;

    public abstract String argumentDescription();

    public List<String> getSuggestions(@Nonnull String prefix) {
        return Collections.emptyList();
    }

    public List<String> getSuggestions(CommandSender sender, @Nonnull String prefix) {
        return this.getSuggestions(prefix);
    }

    protected boolean hasAnnotation(List<? extends Annotation> list, Class<? extends Annotation> a) {
        return list.stream().anyMatch(annotation -> annotation.annotationType().equals(a));
    }
}

