/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.parametric;

import com.jonahseguin.drink.command.DrinkCommand;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.exception.CommandStructureException;
import com.jonahseguin.drink.exception.MissingProviderException;
import com.jonahseguin.drink.parametric.BindingContainer;
import com.jonahseguin.drink.parametric.CommandParameter;
import com.jonahseguin.drink.parametric.CommandParameters;
import com.jonahseguin.drink.parametric.DrinkBinding;
import com.jonahseguin.drink.parametric.DrinkProvider;

public class ProviderAssigner {
    private final DrinkCommandService commandService;

    public ProviderAssigner(DrinkCommandService commandService) {
        this.commandService = commandService;
    }

    public DrinkProvider<?>[] assignProvidersFor(DrinkCommand drinkCommand) throws MissingProviderException, CommandStructureException {
        CommandParameters parameters = drinkCommand.getParameters();
        DrinkProvider[] providers = new DrinkProvider[parameters.getParameters().length];
        for (int i = 0; i < parameters.getParameters().length; ++i) {
            DrinkProvider<?> provider;
            CommandParameter param = parameters.getParameters()[i];
            if (param.isRequireLastArg() && !parameters.isLastArgument(i)) {
                throw new CommandStructureException("Parameter " + param.getParameter().getName() + " [argument " + i + "] (" + param.getParameter().getType().getSimpleName() + ") in method '" + drinkCommand.getMethod().getName() + "' must be the last argument in the method.");
            }
            BindingContainer<?> bindings = this.commandService.getBindingsFor(param.getType());
            if (bindings != null) {
                provider = null;
                for (DrinkBinding<?> binding : bindings.getBindings()) {
                    if (!binding.canProvideFor(param)) continue;
                    provider = binding.getProvider();
                    break;
                }
                if (provider == null) {
                    throw new MissingProviderException("No provider bound for " + param.getType().getSimpleName() + " for parameter " + i + " for method " + drinkCommand.getMethod().getName());
                }
            } else {
                throw new MissingProviderException("No provider bound for " + param.getType().getSimpleName());
            }
            providers[i] = provider;
        }
        return providers;
    }
}

