/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.parametric.binder;

import com.google.common.base.Preconditions;
import com.jonahseguin.drink.command.DrinkCommandService;
import com.jonahseguin.drink.parametric.DrinkProvider;
import com.jonahseguin.drink.provider.InstanceProvider;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DrinkBinder<T> {
    private final DrinkCommandService commandService;
    private final Class<T> type;
    private final Set<Class<? extends Annotation>> classifiers = new HashSet<Class<? extends Annotation>>();
    private DrinkProvider<T> provider;

    public DrinkBinder(DrinkCommandService commandService, Class<T> type) {
        this.commandService = commandService;
        this.type = type;
    }

    public DrinkBinder<T> annotatedWith(@Nonnull Class<? extends Annotation> annotation) {
        Preconditions.checkState((boolean)this.commandService.getModifierService().isClassifier(annotation), (Object)("Annotation " + annotation.getSimpleName() + " must have @Classifer to be bound"));
        this.classifiers.add(annotation);
        return this;
    }

    public void toInstance(@Nonnull T instance) {
        Preconditions.checkNotNull(instance, (Object)("Instance cannot be null for toInstance during binding for " + this.type.getSimpleName()));
        this.provider = new InstanceProvider<T>(instance);
        this.finish();
    }

    public void toProvider(@Nonnull DrinkProvider<T> provider) {
        Preconditions.checkNotNull(provider, (Object)("Provider cannot be null for toProvider during binding for " + this.type.getSimpleName()));
        this.provider = provider;
        this.finish();
    }

    private void finish() {
        this.commandService.bindProvider(this.type, this.classifiers, this.provider);
    }
}

