/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.provider;

import com.google.common.collect.ImmutableList;
import com.jonahseguin.drink.argument.CommandArg;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BooleanProvider
extends DrinkProvider<Boolean> {
    public static final BooleanProvider INSTANCE = new BooleanProvider();
    private static final List<String> SUGGEST = ImmutableList.of((Object)"true", (Object)"false");
    private static final List<String> SUGGEST_TRUE = ImmutableList.of((Object)"true");
    private static final List<String> SUGGEST_FALSE = ImmutableList.of((Object)"false");

    @Override
    public boolean doesConsumeArgument() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public boolean allowNullArgument() {
        return true;
    }

    @Override
    @Nullable
    public Boolean defaultNullValue() {
        return false;
    }

    @Override
    public Boolean provide(@Nonnull CommandArg arg, @Nonnull List<? extends Annotation> annotations) throws CommandExitMessage {
        String s = arg.get();
        if (s == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (NumberFormatException ex) {
            throw new CommandExitMessage("Required: Boolean (true/false), Given: '" + s + "'");
        }
    }

    @Override
    public String argumentDescription() {
        return "true/false";
    }

    @Override
    public List<String> getSuggestions(@Nonnull String prefix) {
        if ((prefix = prefix.toLowerCase()).length() == 0) {
            return SUGGEST;
        }
        if ("true".startsWith(prefix)) {
            return SUGGEST_TRUE;
        }
        if ("false".startsWith(prefix)) {
            return SUGGEST_FALSE;
        }
        return Collections.emptyList();
    }
}

