/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.provider;

import com.jonahseguin.drink.argument.CommandArg;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DateProvider
extends DrinkProvider<Date> {
    public static final DateProvider INSTANCE = new DateProvider();
    public static final String FORMAT_STR = "yyyy-MM-dd@HH:mm";
    public static final DateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd@HH:mm", Locale.ENGLISH);

    @Override
    public boolean doesConsumeArgument() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @Nullable
    public Date provide(@Nonnull CommandArg arg, @Nonnull List<? extends Annotation> annotations) throws CommandExitMessage {
        String s = arg.get();
        try {
            return FORMAT.parse(s);
        }
        catch (ParseException e) {
            throw new CommandExitMessage("Date must be in format: yyyy-MM-dd@HH:mm");
        }
    }

    @Override
    public String argumentDescription() {
        return "date: yyyy-MM-dd@HH:mm";
    }

    @Override
    public List<String> getSuggestions(@Nonnull String prefix) {
        Calendar calendar = Calendar.getInstance();
        return Collections.singletonList(String.format("%d-%02d-%02d@%02d:%02d", calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12)));
    }
}

