/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.provider;

import com.jonahseguin.drink.argument.CommandArg;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DurationProvider
extends DrinkProvider<Date> {
    public static final DurationProvider INSTANCE = new DurationProvider();

    public static long smartParseDuration(String s) {
        if (s.contains(":")) {
            String[] parts = s.split(":");
            String hours = parts[0];
            String minutes = parts[1];
            if (DurationProvider.charCount(':', s) >= 2) {
                String seconds = parts[2];
                try {
                    int h = Integer.parseInt(hours);
                    int m = Integer.parseInt(minutes);
                    int sec = Integer.parseInt(seconds);
                    return (long)h * 60L * 60L * 1000L + (long)m * 60L * 1000L + (long)sec * 1000L;
                }
                catch (NumberFormatException ex) {
                    return 0L;
                }
            }
            try {
                int h = Integer.parseInt(hours);
                int m = Integer.parseInt(minutes);
                return (long)h * 60L * 60L * 1000L + (long)m * 60L * 1000L;
            }
            catch (NumberFormatException ex) {
                return 0L;
            }
        }
        return DurationProvider.parseDurationSimple(s);
    }

    public static long parseDurationSimple(String str) {
        int h = DurationProvider.parseTime(str, 'h');
        int m = DurationProvider.parseTime(str, 'm');
        int s = DurationProvider.parseTime(str, 's');
        if (h == -1 || m == -1 || s == -1) {
            return -1L;
        }
        long hoursToMS = (long)h * 60L * 60L * 1000L;
        long minutesToMS = (long)m * 60L * 1000L;
        long secondsToMS = (long)s * 1000L;
        return hoursToMS + minutesToMS + secondsToMS;
    }

    public static int charCount(char c, String s) {
        int y = 0;
        for (char x : s.toCharArray()) {
            if (x != c) continue;
            ++y;
        }
        return y;
    }

    public static int parseTime(String s, char c) {
        if ((s = s.toLowerCase()).indexOf(c) > -1) {
            if (DurationProvider.charCount(c, s) == 1) {
                int index = s.indexOf(c);
                return DurationProvider.getCountAt(s, index);
            }
            return -1;
        }
        return 0;
    }

    public static int getCountAt(String s, int index) {
        if (index > 0) {
            int start;
            char[] chars = s.toCharArray();
            for (start = index - 1; chars.length > start && start > 0; --start) {
                char c = chars[start];
                System.out.println(c);
                if (!DurationProvider.isTimeModifier(c)) {
                    System.out.println(start);
                    continue;
                }
                ++start;
                break;
            }
            String countStr = s.substring(start, index);
            try {
                return Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                return 0;
            }
        }
        return 0;
    }

    public static boolean isTimeModifier(char c) {
        return c == 'h' || c == 'm' || c == 's';
    }

    @Override
    public boolean doesConsumeArgument() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    @Nullable
    public Date provide(@Nonnull CommandArg arg, @Nonnull List<? extends Annotation> annotations) throws CommandExitMessage {
        String s = arg.get();
        try {
            long l = DurationProvider.smartParseDuration(s);
            if (l != -1L) {
                return new Date(l);
            }
            throw new CommandExitMessage("Duration must be in format hh:mm or hh:mm:ss or 1h2m3s");
        }
        catch (Exception ex) {
            throw new CommandExitMessage("Duration must be in format hh:mm or hh:mm:ss or 1h2m3s");
        }
    }

    @Override
    public String argumentDescription() {
        return "duration";
    }
}

