/*
 * Decompiled with CFR 0.152.
 */
package com.jonahseguin.drink.provider;

import com.google.common.collect.Lists;
import com.jonahseguin.drink.argument.CommandArg;
import com.jonahseguin.drink.exception.CommandExitMessage;
import com.jonahseguin.drink.parametric.DrinkProvider;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class EnumProvider<T extends Enum<T>>
extends DrinkProvider<T> {
    private static final Pattern NON_ALPHANUMERIC = Pattern.compile("[^A-Za-z0-9]");
    private final Class<T> enumClass;

    public EnumProvider(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    private static String simplify(String t) {
        return NON_ALPHANUMERIC.matcher(t.toLowerCase()).replaceAll("");
    }

    @Override
    public boolean doesConsumeArgument() {
        return true;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public T provide(@Nonnull CommandArg arg, @Nonnull List<? extends Annotation> annotations) throws CommandExitMessage {
        String name = arg.get();
        String s = EnumProvider.simplify(name);
        for (Enum entry : (Enum[])this.enumClass.getEnumConstants()) {
            if (!EnumProvider.simplify(entry.name()).equalsIgnoreCase(s)) continue;
            return (T)entry;
        }
        throw new CommandExitMessage("No matching value found for " + this.argumentDescription() + ".  Available values: " + StringUtils.join(this.getSuggestions(arg.getSender(), ""), (char)' '));
    }

    @Override
    public String argumentDescription() {
        return this.enumClass.getSimpleName();
    }

    @Override
    public List<String> getSuggestions(@Nonnull String prefix) {
        ArrayList suggestions = Lists.newArrayList();
        String test = EnumProvider.simplify(prefix);
        for (Enum entry : (Enum[])this.enumClass.getEnumConstants()) {
            String name = EnumProvider.simplify(entry.name());
            if (test.length() != 0 && !name.startsWith(test)) continue;
            suggestions.add(entry.name().toLowerCase());
        }
        return suggestions;
    }
}

