/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.blockChanger;

import dev.lrxh.blockChanger.lighting.LightingService;
import dev.lrxh.blockChanger.snapshot.ChunkListener;
import dev.lrxh.blockChanger.snapshot.ChunkSectionSnapshot;
import dev.lrxh.blockChanger.snapshot.CuboidSnapshot;
import dev.lrxh.blockChanger.util.GroupBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.BitStorage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.apache.logging.log4j.util.InternalApi;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockChanger {
    public static final ExecutorService EXECUTOR = Executors.newVirtualThreadPerTaskExecutor();
    private static final int[][] SHIFT_CACHE = new int[16][];
    private static final long[][] MASK_CACHE = new long[16][];
    private static final PalettedContainer<BlockState> states = new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES, null);
    private static JavaPlugin plugin;

    public static void initialize(JavaPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)new ChunkListener(plugin), (Plugin)plugin);
        for (int bits = 1; bits <= 16; ++bits) {
            int vp = 64 / bits;
            int[] shifts = new int[vp];
            long[] masks = new long[vp];
            long mask = (1L << bits) - 1L;
            for (int p = 0; p < vp; ++p) {
                int s;
                shifts[p] = s = p * bits;
                masks[p] = mask << s;
            }
            BlockChanger.SHIFT_CACHE[bits - 1] = shifts;
            BlockChanger.MASK_CACHE[bits - 1] = masks;
        }
        BlockChanger.plugin = plugin;
    }

    @InternalApi
    public static ChunkSectionSnapshot createChunkBlockSnapshot(Chunk chunk) {
        CraftChunk craftChunk = (CraftChunk)chunk;
        ChunkAccess chunkAccess = craftChunk.getHandle(ChunkStatus.FULL);
        ChunkPos position = chunkAccess.getPos();
        ServerLevel level = craftChunk.getCraftWorld().getHandle();
        LevelChunkSection[] sections = chunkAccess.getSections();
        LevelChunkSection[] copiedSections = new LevelChunkSection[sections.length];
        for (int i = 0; i < sections.length; ++i) {
            LevelChunkSection section = sections[i];
            copiedSections[i] = section != null ? section.copy() : BlockChanger.createEmptySection((Level)level);
        }
        return new ChunkSectionSnapshot(copiedSections, position);
    }

    @InternalApi
    public static CompletableFuture<Void> restoreChunkBlockSnapshot(Chunk chunk, ChunkSectionSnapshot snapshot, boolean clearEntities) {
        return CompletableFuture.runAsync(() -> BlockChanger._restoreChunkBlockSnapshot(chunk, snapshot, clearEntities));
    }

    private static void _restoreChunkBlockSnapshot(Chunk chunk, ChunkSectionSnapshot snapshot, boolean clearEntities) {
        CraftChunk craftChunk = (CraftChunk)chunk;
        ChunkAccess chunkAccess = craftChunk.getHandle(ChunkStatus.FULL);
        ServerLevel level = craftChunk.getCraftWorld().getHandle();
        if (clearEntities) {
            chunkAccess.blockEntities.clear();
            int chunkX = chunk.getX();
            int chunkZ = chunk.getZ();
            for (Entity entity : craftChunk.getCraftWorld().getHandle().moonrise$getEntityLookup().getAll()) {
                if (entity instanceof Player) continue;
                int entityChunkX = (int)Math.floor(entity.getX()) >> 4;
                int entityChunkZ = (int)Math.floor(entity.getZ()) >> 4;
                if (entityChunkX != chunkX || entityChunkZ != chunkZ) continue;
                Bukkit.getScheduler().getMainThreadExecutor((Plugin)plugin).execute(() -> entity.remove(Entity.RemovalReason.DISCARDED));
            }
        }
        LevelChunkSection[] newSections = snapshot.sections();
        BlockChanger.setSections(chunkAccess, newSections, level, true);
    }

    private static void setSections(ChunkAccess chunkAccess, LevelChunkSection[] newSections, ServerLevel level, boolean copy) {
        LevelChunkSection[] currentSections = chunkAccess.getSections();
        if (currentSections.length != newSections.length) {
            throw new IllegalArgumentException("Section count mismatch: expected " + currentSections.length + ", but got " + newSections.length);
        }
        IntStream.range(0, currentSections.length).parallel().forEach(i -> {
            LevelChunkSection section = currentSections[i];
            LevelChunkSection newSection = newSections[i];
            if (section == null) {
                section = BlockChanger.createEmptySection((Level)level);
            }
            if (newSection == null) {
                newSection = BlockChanger.createEmptySection((Level)level);
            }
            if (section.hasOnlyAir() && newSection.hasOnlyAir()) {
                return;
            }
            currentSections[i] = copy ? newSection.copy() : newSection;
        });
    }

    private static LevelChunkSection createEmptySection(Level level) {
        Registry biomeRegistry = level.registryAccess().lookupOrThrow(Registries.BIOME);
        Holder.Reference defaultBiome = biomeRegistry.getOrThrow(Biomes.PLAINS);
        PalettedContainer biomes = new PalettedContainer(biomeRegistry.asHolderIdMap(), (Object)defaultBiome, PalettedContainer.Strategy.SECTION_BIOMES, null);
        LevelChunkSection section = new LevelChunkSection(states, biomes);
        section.recalcBlockCounts();
        return section;
    }

    private static void writePaletteIds(LevelChunkSection section, int[] indices, int[] paletteIds) {
        int n = paletteIds.length;
        if (n == 0) {
            return;
        }
        PalettedContainer container = section.states;
        PalettedContainer.Data data = container.data;
        BitStorage storage = data.storage();
        int bits = storage.getBits();
        if (bits == 0) {
            section.recalcBlockCounts();
            return;
        }
        int valuesPerLong = 64 / bits;
        int[] shifts = SHIFT_CACHE[bits - 1];
        long[] masks = MASK_CACHE[bits - 1];
        long[] raw = storage.getRaw();
        long bitMask = (1L << bits) - 1L;
        int rawLen = raw.length;
        long[] batchMasks = new long[rawLen];
        long[] batchValues = new long[rawLen];
        for (int i = 0; i < n; ++i) {
            int idx = indices[i];
            int pid = paletteIds[i] & (int)bitMask;
            int cell = idx / valuesPerLong;
            int pos = idx % valuesPerLong;
            int n2 = cell;
            batchMasks[n2] = batchMasks[n2] | masks[pos];
            int n3 = cell;
            batchValues[n3] = batchValues[n3] | (long)pid << shifts[pos];
        }
        for (int j = 0; j < rawLen; ++j) {
            raw[j] = raw[j] & (batchMasks[j] ^ 0xFFFFFFFFFFFFFFFFL) | batchValues[j];
        }
        section.recalcBlockCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setAll(LevelChunkSection section, int[] indices, BlockState[] states) {
        int n = states.length;
        if (n == 0) {
            return;
        }
        PalettedContainer container = section.states;
        PalettedContainer.Data data = container.data;
        Palette palette = data.palette();
        int[] paletteIds = new int[n];
        HashMap<BlockState, Integer> paletteCache = new HashMap<BlockState, Integer>(Math.min(n, 16));
        Palette palette2 = palette;
        synchronized (palette2) {
            for (int i = 0; i < n; ++i) {
                BlockState state = states[i];
                Integer id = (Integer)paletteCache.get(state);
                if (id == null) {
                    id = palette.idFor((Object)state);
                    paletteCache.put(state, id);
                }
                paletteIds[i] = id;
            }
        }
        BlockChanger.writePaletteIds(section, indices, paletteIds);
    }

    public static CompletableFuture<Void> setBlocks(Map<Location, BlockData> blocks, boolean updateLighting) {
        if (blocks == null || blocks.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ServerLevel level = ((CraftChunk)blocks.keySet().iterator().next().getChunk()).getCraftWorld().getHandle();
        World bukkitWorld = blocks.keySet().iterator().next().getWorld();
        ConcurrentHashMap stateCache = new ConcurrentHashMap(Math.max(16, blocks.size() >>> 2));
        ConcurrentHashMap groups = new ConcurrentHashMap(Math.max(16, blocks.size() >>> 4));
        blocks.entrySet().parallelStream().forEach(entry -> {
            Location loc = (Location)entry.getKey();
            BlockData bd = (BlockData)entry.getValue();
            long chunkKey = (long)(loc.getBlockX() >> 4) << 32 | (long)(loc.getBlockZ() >> 4) & 0xFFFFFFFFL;
            int sectionIndex = level.getSectionIndex(loc.getBlockY());
            long combinedKey = chunkKey << 4 | (long)(sectionIndex & 0xF);
            BlockState state = stateCache.computeIfAbsent(bd, k -> ((CraftBlockData)k).getState());
            int bx = loc.getBlockX();
            int by = loc.getBlockY();
            int bz = loc.getBlockZ();
            int idx = (by & 0xF) << 8 | (bz & 0xF) << 4 | bx & 0xF;
            groups.computeIfAbsent(combinedKey, k -> new GroupBuffer(8)).append(idx, state);
        });
        ConcurrentHashMap chunkCache = new ConcurrentHashMap();
        List<CompletableFuture> chunkFutures = groups.entrySet().stream().map(entry -> {
            long combinedKey = (Long)entry.getKey();
            GroupBuffer gb = (GroupBuffer)entry.getValue();
            int sectionIndex = (int)(combinedKey & 0xFL);
            long chunkKey = combinedKey >>> 4;
            int chunkX = (int)(chunkKey >> 32);
            int chunkZ = (int)(chunkKey & 0xFFFFFFFFL);
            CompletableFuture chunkFuture = chunkCache.computeIfAbsent(chunkKey, k -> bukkitWorld.getChunkAtAsync(chunkX, chunkZ, false));
            return chunkFuture.thenRunAsync(() -> {
                int n;
                ChunkAccess access = ((CraftChunk)chunkFuture.join()).getHandle(ChunkStatus.FULL);
                LevelChunkSection[] sections = access.getSections();
                LevelChunkSection section = sections[sectionIndex];
                if (section == null) {
                    sections[sectionIndex] = section = BlockChanger.createEmptySection((Level)level);
                }
                GroupBuffer groupBuffer = gb;
                synchronized (groupBuffer) {
                    n = gb.size;
                }
                if (n == 0) {
                    return;
                }
                int[] indices = new int[n];
                BlockState[] states = new BlockState[n];
                GroupBuffer groupBuffer2 = gb;
                synchronized (groupBuffer2) {
                    System.arraycopy(gb.indices, 0, indices, 0, n);
                    System.arraycopy(gb.states, 0, states, 0, n);
                }
                BlockChanger.setAll(section, indices, states);
            });
        }).toList();
        return CompletableFuture.allOf(chunkFutures.toArray(new CompletableFuture[0])).thenRunAsync(() -> {
            if (updateLighting && !groups.isEmpty()) {
                Set<Chunk> changedChunks = chunkCache.values().stream().map(CompletableFuture::join).collect(Collectors.toSet());
                LightingService.updateLighting(changedChunks, true);
            }
        });
    }

    public static CompletableFuture<Void> updateLighting(Set<Chunk> chunks) {
        return CompletableFuture.runAsync(() -> LightingService.updateLighting(chunks, true));
    }

    public static CompletableFuture<Void> restoreCuboidSnapshotAsync(CuboidSnapshot snapshot, boolean clearEntities) {
        return CompletableFuture.runAsync(() -> BlockChanger.restoreCuboidSnapshot(snapshot, clearEntities));
    }

    public static void restoreCuboidSnapshot(CuboidSnapshot snapshot, boolean clearEntities) {
        CompletableFuture[] futures = (CompletableFuture[])snapshot.getSnapshots().entrySet().stream().map(entry -> {
            Chunk chunk = (Chunk)entry.getKey();
            ChunkSectionSnapshot section = (ChunkSectionSnapshot)entry.getValue();
            return BlockChanger.restoreChunkBlockSnapshot(chunk, section, clearEntities).thenRun(() -> chunk.getWorld().refreshChunk(chunk.getX(), chunk.getZ()));
        }).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).thenRun(() -> LightingService.updateLighting(snapshot.getSnapshots().keySet(), false));
    }
}

