/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.blockChanger.snapshot;

import dev.lrxh.blockChanger.BlockChanger;
import dev.lrxh.blockChanger.snapshot.QueuedChunkSnapshot;
import dev.lrxh.blockChanger.snapshot.SnapshotService;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChunkListener
implements Listener {
    private final JavaPlugin plugin;

    public ChunkListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChunkLoad(ChunkLoadEvent event) {
        QueuedChunkSnapshot queuedChunkSnapshot = SnapshotService.getSnapshot(new ChunkPos(event.getChunk().getX(), event.getChunk().getZ()));
        if (queuedChunkSnapshot == null) {
            return;
        }
        if (event.getChunk().getWorld().getName() != queuedChunkSnapshot.worldName()) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> BlockChanger.restoreChunkBlockSnapshot(event.getChunk(), queuedChunkSnapshot.snapshot(), true));
    }
}

