/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.blockChanger.snapshot;

import dev.lrxh.blockChanger.BlockChanger;
import dev.lrxh.blockChanger.snapshot.ChunkPosition;
import dev.lrxh.blockChanger.snapshot.ChunkSectionSnapshot;
import dev.lrxh.blockChanger.snapshot.SnapshotService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class CuboidSnapshot {
    private final Map<Chunk, ChunkSectionSnapshot> snapshots;

    private CuboidSnapshot(Map<Chunk, ChunkSectionSnapshot> snapshots) {
        this.snapshots = Collections.unmodifiableMap(snapshots);
        snapshots.forEach((chunk, snapshot) -> SnapshotService.addSnapshot(snapshot, chunk.getWorld()));
    }

    public static CompletableFuture<CuboidSnapshot> create(Location pos1, Location pos2) {
        World world = pos1.getWorld();
        int minChunkX = Math.min(pos1.getChunk().getX(), pos2.getChunk().getX());
        int maxChunkX = Math.max(pos1.getChunk().getX(), pos2.getChunk().getX());
        int minChunkZ = Math.min(pos1.getChunk().getZ(), pos2.getChunk().getZ());
        int maxChunkZ = Math.max(pos1.getChunk().getZ(), pos2.getChunk().getZ());
        int totalChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
        return CuboidSnapshot.loadChunksAndSnapshots(totalChunks, (x, z) -> world.getChunkAtAsync(x.intValue(), z.intValue()).thenApplyAsync(chunk -> Map.entry(chunk, BlockChanger.createChunkBlockSnapshot(chunk)), (Executor)BlockChanger.EXECUTOR), minChunkX, maxChunkX, minChunkZ, maxChunkZ);
    }

    private static CompletableFuture<CuboidSnapshot> loadChunksAndSnapshots(int totalChunks, BiFunction<Integer, Integer, CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>> loader, int minChunkX, int maxChunkX, int minChunkZ, int maxChunkZ) {
        ArrayList<CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>> futures = new ArrayList<CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>>(totalChunks);
        for (int x = minChunkX; x <= maxChunkX; ++x) {
            for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                futures.add(loader.apply(x, z));
            }
        }
        return CuboidSnapshot.combineFutures(futures);
    }

    private static CompletableFuture<CuboidSnapshot> combineFutures(List<CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
            HashMap<Chunk, ChunkSectionSnapshot> result = new HashMap<Chunk, ChunkSectionSnapshot>(futures.size(), 0.9f);
            for (CompletableFuture future : futures) {
                Map.Entry entry = (Map.Entry)future.join();
                result.put((Chunk)entry.getKey(), (ChunkSectionSnapshot)entry.getValue());
            }
            return new CuboidSnapshot(result);
        });
    }

    public Map<Chunk, ChunkSectionSnapshot> getSnapshots() {
        return this.snapshots;
    }

    public CompletableFuture<Void> restoreAsync(boolean clearEntities) {
        return BlockChanger.restoreCuboidSnapshotAsync(this, clearEntities);
    }

    public void restore(boolean clearEntities) {
        BlockChanger.restoreCuboidSnapshot(this, clearEntities);
    }

    public CuboidSnapshot clone() {
        return new CuboidSnapshot(new HashMap<Chunk, ChunkSectionSnapshot>(this.snapshots));
    }

    public CompletableFuture<CuboidSnapshot> offset(int xOffset, int zOffset) {
        return this.offset(xOffset, zOffset, new HashMap<ChunkPosition, Chunk>());
    }

    public CompletableFuture<CuboidSnapshot> offset(int xOffset, int zOffset, Map<ChunkPosition, Chunk> preloadedChunks) {
        if (this.snapshots.isEmpty()) {
            return CompletableFuture.completedFuture(new CuboidSnapshot(Collections.emptyMap()));
        }
        if (xOffset % 16 != 0 || zOffset % 16 != 0) {
            throw new IllegalArgumentException("Offsets must be multiples of 16.");
        }
        int chunkOffsetX = xOffset / 16;
        int chunkOffsetZ = zOffset / 16;
        ArrayList<CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>> futures = new ArrayList<CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>>(this.snapshots.size());
        ExecutorService executor = BlockChanger.EXECUTOR;
        for (Map.Entry<Chunk, ChunkSectionSnapshot> entry : this.snapshots.entrySet()) {
            Chunk originalChunk = entry.getKey();
            ChunkSectionSnapshot snapshot = entry.getValue();
            int newX = originalChunk.getX() + chunkOffsetX;
            int newZ = originalChunk.getZ() + chunkOffsetZ;
            ChunkPosition newPos = new ChunkPosition(newX, newZ);
            CompletableFuture chunkFuture = Optional.ofNullable(preloadedChunks.get(newPos)).map(CompletableFuture::completedFuture).orElseGet(() -> originalChunk.getWorld().getChunkAtAsync(newX, newZ));
            futures.add((CompletableFuture<Map.Entry<Chunk, ChunkSectionSnapshot>>)chunkFuture.thenApplyAsync(chunk -> Map.entry(chunk, snapshot), (Executor)executor));
        }
        return CuboidSnapshot.combineFutures(futures);
    }
}

