/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.configs;

import dev.lrxh.neptune.configs.impl.CosmeticsLocale;
import dev.lrxh.neptune.configs.impl.HotbarLocale;
import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.configs.impl.ScoreboardLocale;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.utils.ConfigFile;
import lombok.Generated;

public class ConfigService {
    private static ConfigService instance;
    private ConfigFile messagesConfig;
    private ConfigFile arenasConfig;
    private ConfigFile kitsConfig;
    private ConfigFile mainConfig;
    private ConfigFile scoreboardConfig;
    private ConfigFile hotbarConfig;
    private ConfigFile menusConfig;
    private ConfigFile divisionsConfig;
    private ConfigFile cosmeticsConfig;
    private ConfigFile killMessagesConfig;

    public static ConfigService get() {
        if (instance == null) {
            instance = new ConfigService();
        }
        return instance;
    }

    public void load() {
        this.messagesConfig = new ConfigFile("messages");
        this.arenasConfig = new ConfigFile("arenas");
        this.kitsConfig = new ConfigFile("kits");
        this.mainConfig = new ConfigFile("settings");
        this.scoreboardConfig = new ConfigFile("scoreboard");
        this.hotbarConfig = new ConfigFile("hotbar");
        this.menusConfig = new ConfigFile("menus");
        this.divisionsConfig = new ConfigFile("divisions");
        this.cosmeticsConfig = new ConfigFile("cosmetics");
        this.killMessagesConfig = new ConfigFile("kill-messages");
        this.initialize();
    }

    public void initialize() {
        HotbarLocale.LOBBY_PARTY_CREATE_NAME.load();
        MessagesLocale.MATCH_FOUND.load();
        SettingsLocale.SPAWN_LOCATION.load();
        MenusLocale.FILTER_NAME.load();
        ScoreboardLocale.TITLE.load();
        CosmeticsLocale.LIGHTNING_DISPLAY_NAME.load();
    }

    @Generated
    public ConfigFile getMessagesConfig() {
        return this.messagesConfig;
    }

    @Generated
    public ConfigFile getArenasConfig() {
        return this.arenasConfig;
    }

    @Generated
    public ConfigFile getKitsConfig() {
        return this.kitsConfig;
    }

    @Generated
    public ConfigFile getMainConfig() {
        return this.mainConfig;
    }

    @Generated
    public ConfigFile getScoreboardConfig() {
        return this.scoreboardConfig;
    }

    @Generated
    public ConfigFile getHotbarConfig() {
        return this.hotbarConfig;
    }

    @Generated
    public ConfigFile getMenusConfig() {
        return this.menusConfig;
    }

    @Generated
    public ConfigFile getDivisionsConfig() {
        return this.divisionsConfig;
    }

    @Generated
    public ConfigFile getCosmeticsConfig() {
        return this.cosmeticsConfig;
    }

    @Generated
    public ConfigFile getKillMessagesConfig() {
        return this.killMessagesConfig;
    }
}

