/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.configs.impl;

import dev.lrxh.neptune.configs.ConfigService;
import dev.lrxh.neptune.configs.impl.handler.DataType;
import dev.lrxh.neptune.configs.impl.handler.IDataAccessor;
import dev.lrxh.neptune.utils.ConfigFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public enum SettingsLocale implements IDataAccessor
{
    FRIENDLY_FIRE("FRIENDLY_FIRE", DataType.BOOLEAN, "false"),
    COMMANDS_AFTER_MATCH_WINNER("COMMAND_AFTER_MATCH.WINNER", DataType.STRING_LIST, "NONE"),
    COMMANDS_AFTER_MATCH_LOSER("COMMAND_AFTER_MATCH.LOSER", DataType.STRING_LIST, "NONE"),
    SPAWN_LOCATION("SPAWN.LOCATION", DataType.STRING, "NONE"),
    LEADERBOARD_UPDATE_TIME("LEADERBOARD.UPDATE_TIME", "How often leaderboards should check in ticks (20 ticks = 1 second).", DataType.INT, "10"),
    DATABASE_TYPE("DATABASE.TYPE", "Database Type. MONGO, SQLITE", DataType.STRING, "SQLITE"),
    URI("DATABASE.URI", "Connection URI.", DataType.STRING, "NONE"),
    DATABASE("DATABASE.DATABASE_NAME", "Database Name", DataType.STRING, "neptune"),
    PARTICIPANT_COLOR_BLUE("PARTICIPANT.COLOR.BLUE", "", DataType.STRING, "&9"),
    PARTICIPANT_COLOR_RED("PARTICIPANT.COLOR.RED", "", DataType.STRING, "&c"),
    REQUEST_EXPIRY_TIME("REQUEST.EXPIRY_TIME", "How long a request should last in seconds.", DataType.INT, "30"),
    ARENA_DUPLICATES("ARENA.DUPLICATES", "Should neptune duplicate the arena on match start (EXPERIMENTAL)", DataType.BOOLEAN, "false"),
    ARENA_COPY_OFFSET_X("ARENA.COPY_OFFSET.X", "The offset in the X direction when duplicating an arena. (This value most be dividable by 16)", DataType.INT, "496"),
    ARENA_COPY_OFFSET_Z("ARENA.COPY_OFFSET.Z", "The offset in the Z direction when duplicating an arena. (This value most be dividable by 16)", DataType.INT, "0"),
    IN_MATCH_BLOCKED_COMMANDS("IN_MATCH.BLOCK_COMMANDS", "Commands which the player can't run during a match.", DataType.STRING_LIST, ""),
    PARTY_ADVERTISE_TIME("PARTY.ADVERTISE_TIME", "The time it should take for sending each message for party advertisements, in ticks (20 ticks = 1 second).", DataType.INT, "6000");

    private final String path;
    private final String comment;
    private final List<String> defaultValue = new ArrayList<String>();
    private final DataType dataType;

    private SettingsLocale(String path, String comment, DataType dataType, String ... defaultValue) {
        this.path = path;
        this.comment = comment;
        this.defaultValue.addAll(Arrays.asList(defaultValue));
        this.dataType = dataType;
    }

    private SettingsLocale(String path, DataType dataType, String ... defaultValue) {
        this.path = path;
        this.comment = null;
        this.defaultValue.addAll(Arrays.asList(defaultValue));
        this.dataType = dataType;
    }

    @Override
    public String getHeader() {
        return "";
    }

    @Override
    public ConfigFile getConfigFile() {
        return ConfigService.get().getMainConfig();
    }

    @Override
    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public String getComment() {
        return this.comment;
    }

    @Override
    @Generated
    public List<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Generated
    public DataType getDataType() {
        return this.dataType;
    }
}

