/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.configs.impl.handler;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.handler.DataType;
import dev.lrxh.neptune.utils.ConfigFile;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public interface IDataAccessor {
    public static final Neptune plugin = Neptune.get();

    default public String getString() {
        return this.getConfigFile().getConfiguration().getString(this.getPath());
    }

    default public List<String> getStringList() {
        return this.getConfigFile().getConfiguration().getStringList(this.getPath());
    }

    default public int getInt() {
        return this.getConfigFile().getConfiguration().getInt(this.getPath());
    }

    default public boolean getBoolean() {
        return this.getConfigFile().getConfiguration().getBoolean(this.getPath());
    }

    default public boolean resetUnknown() {
        return true;
    }

    public String getHeader();

    public String getPath();

    public String getComment();

    public List<String> getDefaultValue();

    public DataType getDataType();

    public ConfigFile getConfigFile();

    default public void applyHeader() {
        String header = this.getHeader();
        if (!header.isEmpty()) {
            this.getConfigFile().getConfiguration().options().setHeader(List.of(header));
        }
    }

    default public void setValue(String path, List<String> rawValue, DataType type) {
        switch (type) {
            case STRING_LIST: {
                this.getConfigFile().getConfiguration().set(path, rawValue);
                break;
            }
            case STRING: {
                this.getConfigFile().getConfiguration().set(path, (Object)rawValue.get(0));
                break;
            }
            case INT: {
                this.getConfigFile().getConfiguration().set(path, (Object)Integer.parseInt(rawValue.get(0)));
                break;
            }
            case BOOLEAN: {
                this.getConfigFile().getConfiguration().set(path, (Object)Boolean.parseBoolean(rawValue.get(0)));
            }
        }
    }

    default public void set(Object value) {
        this.getConfigFile().getConfiguration().set(this.getPath(), value);
        this.getConfigFile().save();
    }

    default public void comment(String path, String comment) {
        if (comment != null) {
            this.getConfigFile().getConfiguration().setInlineComments(path, Collections.singletonList(comment));
            this.getConfigFile().save();
        }
    }

    default public void load() {
        this.applyHeader();
        ConfigFile cfgFile = this.getConfigFile();
        if (cfgFile == null) {
            return;
        }
        YamlConfiguration root = cfgFile.getConfiguration();
        List<IDataAccessor> accessors = List.of((IDataAccessor[])this.getClass().getEnumConstants());
        for (IDataAccessor a : accessors) {
            if (root.get(a.getPath()) != null) continue;
            this.setValue(a.getPath(), a.getDefaultValue(), a.getDataType());
            this.comment(a.getPath(), a.getComment());
        }
        if (this.resetUnknown()) {
            Set<String> valid = accessors.stream().map(IDataAccessor::getPath).collect(Collectors.toSet());
            this.cleanupSection((ConfigurationSection)root, "", valid);
        }
        cfgFile.save();
    }

    private void cleanupSection(ConfigurationSection section, String parentPath, Set<String> validPaths) {
        for (String key : section.getKeys(false)) {
            String fullPath;
            String string = fullPath = parentPath.isEmpty() ? key : parentPath + "." + key;
            if (section.isConfigurationSection(key)) {
                this.cleanupSection(section.getConfigurationSection(key), fullPath, validPaths);
                ConfigurationSection nested = section.getConfigurationSection(key);
                boolean hasValidChild = validPaths.stream().anyMatch(p -> p.startsWith(fullPath + "."));
                if (!nested.getKeys(false).isEmpty() || hasValidChild) continue;
                section.set(key, null);
                continue;
            }
            if (validPaths.contains(fullPath)) continue;
            section.set(key, null);
        }
    }
}

