/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.cosmetics;

import dev.lrxh.api.features.ICosmeticService;
import dev.lrxh.api.features.IKillMessagePackage;
import dev.lrxh.neptune.configs.ConfigService;
import dev.lrxh.neptune.feature.cosmetics.impl.KillMessagePackage;
import dev.lrxh.neptune.providers.manager.IService;
import dev.lrxh.neptune.utils.ConfigFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CosmeticService
extends IService
implements ICosmeticService {
    private static CosmeticService instance;
    public final Map<String, KillMessagePackage> deathMessages = new HashMap<String, KillMessagePackage>();

    public CosmeticService() {
        this.load();
    }

    public static CosmeticService get() {
        if (instance == null) {
            instance = new CosmeticService();
        }
        return instance;
    }

    @Override
    public Map<String, IKillMessagePackage> getDeathMessages() {
        return this.deathMessages.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (IKillMessagePackage)entry.getValue()), HashMap::putAll);
    }

    @Override
    public void load() {
        YamlConfiguration config = ConfigService.get().getKillMessagesConfig().getConfiguration();
        if (config.contains("KILL_MESSAGES")) {
            for (String deathPackageName : this.getKeys((FileConfiguration)config, "KILL_MESSAGES")) {
                String path = "KILL_MESSAGES." + deathPackageName + ".";
                String displayName = config.getString(path + "DISPLAY_NAME");
                Material material = Material.getMaterial((String)Objects.requireNonNull(config.getString(path + "MATERIAL")));
                List description = config.getStringList(path + "DESCRIPTION");
                int slot = config.getInt(path + "SLOT");
                List messages = config.getStringList(path + "MESSAGES");
                this.deathMessages.put(deathPackageName, new KillMessagePackage(deathPackageName, displayName, material, description, slot, messages));
            }
        }
    }

    @Override
    public void registerKillMessage(IKillMessagePackage killMessagePackage) {
        this.deathMessages.put(killMessagePackage.getName(), (KillMessagePackage)killMessagePackage);
    }

    @Override
    public void save() {
    }

    @Override
    public ConfigFile getConfigFile() {
        return ConfigService.get().getCosmeticsConfig();
    }

    public KillMessagePackage getDeathMessagePackage(String packageName) {
        if (!this.deathMessages.containsKey(packageName)) {
            return this.getDefault();
        }
        return this.deathMessages.get(packageName);
    }

    public KillMessagePackage getDefault() {
        return this.deathMessages.get("DEFAULT");
    }
}

