/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.cosmetics.impl;

import dev.lrxh.neptune.configs.impl.CosmeticsLocale;
import dev.lrxh.neptune.utils.RandomUtils;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public enum KillEffect {
    NONE(CosmeticsLocale.NONE_DISPLAY_NAME.getString(), Material.valueOf((String)CosmeticsLocale.NONE_MATERIAL.getString()), CosmeticsLocale.NONE_SLOT.getInt()){}
    ,
    LIGHTNING(CosmeticsLocale.LIGHTNING_DISPLAY_NAME.getString(), Material.valueOf((String)CosmeticsLocale.LIGHTNING_MATERIAL.getString()), CosmeticsLocale.LIGHTNING_SLOT.getInt()){

        @Override
        public void execute(Player player, Player killer) {
            Location location = player.getLocation();
            double x = location.getX();
            double y = location.getY() + 2.0;
            double z = location.getZ();
            location.getWorld().strikeLightningEffect(new Location(location.getWorld(), x, y, z));
        }
    }
    ,
    FIREWORKS(CosmeticsLocale.FIREWORKS_DISPLAY_NAME.getString(), Material.valueOf((String)CosmeticsLocale.FIREWORKS_MATERIAL.getString()), CosmeticsLocale.FIREWORKS_SLOT.getInt()){

        @Override
        public void execute(Player player, Player killer) {
            this.playEffect(Particle.FIREWORK, killer, player.getLocation(), 50, 5);
        }
    }
    ,
    ANGRY(CosmeticsLocale.ANGRY_DISPLAY_NAME.getString(), Material.valueOf((String)CosmeticsLocale.ANGRY_MATERIAL.getString()), CosmeticsLocale.ANGRY_SLOT.getInt()){

        @Override
        public void execute(Player player, Player killer) {
            this.playEffect(Particle.ANGRY_VILLAGER, killer, player.getLocation(), 25, 5);
        }
    }
    ,
    HEARTS(CosmeticsLocale.HEARTS_DISPLAY_NAME.getString(), Material.valueOf((String)CosmeticsLocale.HEARTS_MATERIAL.getString()), CosmeticsLocale.HEARTS_SLOT.getInt()){

        @Override
        public void execute(Player player, Player killer) {
            this.playEffect(Particle.HEART, killer, player.getLocation(), 25, 5);
        }
    }
    ,
    LAVA(CosmeticsLocale.LAVA_DISPLAY_NAME.getString(), Material.valueOf((String)CosmeticsLocale.LAVA_MATERIAL.getString()), CosmeticsLocale.LAVA_SLOT.getInt()){

        @Override
        public void execute(Player player, Player killer) {
            this.playEffect(Particle.FLAME, killer, player.getLocation(), 25, 5);
        }
    };

    private final String displayName;
    private final Material material;
    private final int slot;

    private KillEffect(String displayName, Material material, int slot) {
        this.displayName = displayName;
        this.material = material;
        this.slot = slot;
    }

    public void execute(Player player, Player killer) {
    }

    public void playEffect(final Particle particle, final Player player, final Location location, final int amount, final int duration) {
        new NeptuneRunnable(this){
            final int maxTicks;
            int ticks;
            {
                this.maxTicks = duration * 20;
                this.ticks = 0;
            }

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.stop();
                    return;
                }
                player.spawnParticle(particle, location, amount, (double)RandomUtils.getRandFloat(0.0f, 0.7f), 1.0, (double)RandomUtils.getRandFloat(0.0f, 0.7f), 0.05, null);
                this.ticks += 10;
            }
        }.start(10L);
    }

    public String permission() {
        return "neptune.cosmetics.kill-effects." + this.name().toLowerCase();
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public Material getMaterial() {
        return this.material;
    }

    @Generated
    public int getSlot() {
        return this.slot;
    }
}

