/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.cosmetics.menu.killEffects;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.cosmetics.impl.KillEffect;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class KillEffectButton
extends Button {
    private final KillEffect killEffect;

    public KillEffectButton(int slot, KillEffect killEffect) {
        super(slot);
        this.killEffect = killEffect;
    }

    @Override
    public void onClick(ClickType type, Player player) {
        if (!player.hasPermission(this.killEffect.permission())) {
            return;
        }
        API.getProfile(player).getSettingData().setKillEffect(this.killEffect);
    }

    @Override
    public ItemStack getItemStack(Player player) {
        Profile profile = API.getProfile(player);
        if (profile == null) {
            return null;
        }
        boolean selected = profile.getSettingData().getKillEffect().equals((Object)this.killEffect);
        List<String> lore = player.hasPermission(this.killEffect.permission()) ? (selected ? MenusLocale.KILL_EFFECTS_SELECTED_LORE.getStringList() : MenusLocale.KILL_EFFECTS_UNSELECTED_LORE.getStringList()) : MenusLocale.KILL_EFFECTS_NO_PERMISSION_LORE.getStringList();
        return new ItemBuilder(this.killEffect.getMaterial()).name(selected ? MenusLocale.KILL_EFFECTS_NAME_SELECTED.getString().replace("<displayName>", this.killEffect.getDisplayName()) : MenusLocale.KILL_EFFECTS_NAME_NOT_SELECTED.getString().replace("<displayName>", this.killEffect.getDisplayName())).lore(lore, player).build();
    }
}

