/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.cosmetics.menu.killMessages;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.cosmetics.impl.KillMessagePackage;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class KillMessageButton
extends Button {
    private final KillMessagePackage killMessagePackage;

    public KillMessageButton(int slot, KillMessagePackage killMessagePackage) {
        super(slot);
        this.killMessagePackage = killMessagePackage;
    }

    @Override
    public void onClick(ClickType type, Player player) {
        if (!player.hasPermission(this.killMessagePackage.permission())) {
            return;
        }
        API.getProfile(player).getSettingData().setKillMessagePackage(this.killMessagePackage);
    }

    @Override
    public ItemStack getItemStack(Player player) {
        Profile profile = API.getProfile(player);
        if (profile == null) {
            return null;
        }
        boolean selected = profile.getSettingData().getKillMessagePackage().equals(this.killMessagePackage);
        List<String> lore = player.hasPermission(this.killMessagePackage.permission()) ? (selected ? MenusLocale.KILL_MESSAGES_SELECTED_LORE.getStringList() : MenusLocale.KILL_MESSAGES_UNSELECTED_LORE.getStringList()) : MenusLocale.KILL_MESSAGES_NO_PERMISSION_LORE.getStringList();
        return new ItemBuilder(this.killMessagePackage.getMaterial()).name(selected ? MenusLocale.KILL_MESSAGES_NAME_SELECTED.getString().replace("<displayName>", this.killMessagePackage.getDisplayName()) : MenusLocale.KILL_MESSAGES_NAME_NOT_SELECTED.getString().replace("<displayName>", this.killMessagePackage.getDisplayName())).lore(ItemUtils.getLore(lore, new Replacement("<description>", this.killMessagePackage.getDescription()), new Replacement("<messages>", ItemUtils.getLore(this.killMessagePackage.getMessages(), new Replacement("<player>", player.getName()), new Replacement("<killer>", player.getName())))), player).build();
    }
}

