/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.divisions;

import dev.lrxh.api.data.IDivision;
import dev.lrxh.api.features.IDivisionService;
import dev.lrxh.neptune.configs.ConfigService;
import dev.lrxh.neptune.feature.divisions.impl.Division;
import dev.lrxh.neptune.providers.manager.IService;
import dev.lrxh.neptune.utils.ConfigFile;
import java.util.AbstractCollection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class DivisionService
extends IService
implements IDivisionService {
    private static DivisionService instance;
    public LinkedHashSet<Division> divisions = new LinkedHashSet();

    public static DivisionService get() {
        if (instance == null) {
            instance = new DivisionService();
        }
        return instance;
    }

    @Override
    public LinkedHashSet<IDivision> getDivisions() {
        return this.divisions.stream().collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    @Override
    public void load() {
        YamlConfiguration config = ConfigService.get().getDivisionsConfig().getConfiguration();
        if (config.contains("DIVISIONS")) {
            for (String divisionName : this.getKeys("DIVISIONS")) {
                String path = "DIVISIONS." + divisionName + ".";
                String displayName = config.getString(path + "DISPLAY-NAME");
                int eloRequired = config.getInt(path + "ELO-REQUIRED", 0);
                Material material = Material.getMaterial((String)Objects.requireNonNull(config.getString(path + "MATERIAL")));
                int slot = config.getInt(path + "SLOT", this.divisions.size());
                this.divisions.add(new Division(divisionName, displayName, eloRequired, material, slot));
            }
        }
        this.divisions = this.divisions.stream().sorted(Comparator.comparingInt(Division::getEloRequired).reversed()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public void registerDivision(IDivision division) {
        this.divisions.add((Division)division);
        this.divisions = this.divisions.stream().sorted(Comparator.comparingInt(Division::getEloRequired).reversed()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public void save() {
    }

    @Override
    public Division getDivisionByElo(int elo) {
        for (Division division : this.divisions) {
            if (elo < division.getEloRequired()) continue;
            return division;
        }
        return (Division)this.divisions.iterator().next();
    }

    @Override
    public ConfigFile getConfigFile() {
        return ConfigService.get().getDivisionsConfig();
    }
}

