/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.divisions.menu;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.divisions.DivisionService;
import dev.lrxh.neptune.feature.divisions.impl.Division;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.Menu;
import dev.lrxh.neptune.utils.menu.impl.DisplayButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DivisionsMenu
extends Menu {
    public DivisionsMenu() {
        super(MenusLocale.DIVISIONS_TITLE.getString(), MenusLocale.DIVISIONS_SIZE.getInt(), Filter.valueOf(MenusLocale.DIVISIONS_FILTER.getString()));
    }

    @Override
    public List<Button> getButtons(Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        ArrayList<Division> divisions = new ArrayList<Division>(DivisionService.get().divisions);
        Collections.reverse(divisions);
        for (Division division : divisions) {
            buttons.add(new DisplayButton(division.getSlot(), this.getItemStack(player, division)));
        }
        return buttons;
    }

    public ItemStack getItemStack(Player player, Division division) {
        return new ItemBuilder(division.getMaterial()).name(MenusLocale.DIVISIONS_ITEM_NAME.getString().replace("<division>", division.getDisplayName())).lore(ItemUtils.getLore(MenusLocale.DIVISIONS_LORE.getStringList(), new Replacement("<elo>", String.valueOf(division.getEloRequired()))), player).build();
    }
}

