/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.hotbar;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.ConfigService;
import dev.lrxh.neptune.feature.hotbar.impl.CustomItem;
import dev.lrxh.neptune.feature.hotbar.impl.Hotbar;
import dev.lrxh.neptune.feature.hotbar.impl.Item;
import dev.lrxh.neptune.feature.hotbar.impl.ItemAction;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.providers.manager.IService;
import dev.lrxh.neptune.utils.ConfigFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class HotbarService
extends IService {
    private static HotbarService instance;
    private final Map<ProfileState, Hotbar> items = new HashMap<ProfileState, Hotbar>();
    private final Neptune plugin = Neptune.get();

    public static HotbarService get() {
        if (instance == null) {
            instance = new HotbarService();
        }
        return instance;
    }

    Item getItem(Hotbar inventory, int slot) {
        Item[] slots = inventory.getSlots();
        if (slot >= 0 && slot < slots.length) {
            return slots[slot];
        }
        return null;
    }

    public void giveItems(Player player) {
        player.getInventory().clear();
        ProfileState profileState = API.getProfile(player).getState();
        if (profileState.equals(ProfileState.IN_KIT_EDITOR)) {
            return;
        }
        Hotbar inventory = this.items.get(profileState);
        if (inventory != null) {
            for (int slot = 0; slot <= 8; ++slot) {
                Item item = this.getItemForSlot(inventory, slot);
                if (item == null || !item.isEnabled()) continue;
                player.getInventory().setItem((int)item.getSlot(), item.constructItem(player.getUniqueId()));
            }
        }
        player.updateInventory();
    }

    public Item getItemForSlot(Hotbar inventory, int slot) {
        return this.getItem(inventory, slot);
    }

    @Override
    public void load() {
        YamlConfiguration config = ConfigService.get().getHotbarConfig().getConfiguration();
        if (config.getConfigurationSection("ITEMS") != null) {
            for (String section : this.getKeys("ITEMS")) {
                Hotbar inventory = new Hotbar();
                for (String itemName : this.getKeys("ITEMS." + section)) {
                    String path = "ITEMS." + section + "." + itemName + ".";
                    String displayName = config.getString(path + "NAME");
                    String material = config.getString(path + "MATERIAL");
                    List lore = config.getStringList(path + "LORE");
                    boolean enabled = config.getBoolean(path + "ENABLED");
                    byte slot = (byte)config.getInt(path + "SLOT");
                    int customModelData = config.getInt(path + "CUSTOM_MODEL_DATA", 0);
                    if (!enabled) continue;
                    try {
                        Item item = new Item(ItemAction.valueOf(itemName), displayName, material, lore, enabled, slot, customModelData);
                        if (slot >= 0 && slot < inventory.getSlots().length) {
                            inventory.setSlot(slot, item);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    this.items.put(ProfileState.valueOf(section), inventory);
                }
            }
        }
        if (config.getConfigurationSection("CUSTOM_ITEMS") != null) {
            for (String itemName : this.getKeys("CUSTOM_ITEMS")) {
                String path = "CUSTOM_ITEMS." + itemName + ".";
                String displayName = config.getString(path + "NAME");
                String material = config.getString(path + "MATERIAL");
                byte slot = (byte)config.getInt(path + "SLOT");
                List lore = config.getStringList(path + "LORE");
                String command = config.getString(path + "COMMAND");
                ProfileState profileState = ProfileState.valueOf(config.getString(path + "STATE"));
                int customModelData = config.getInt(path + "CUSTOM_MODEL_DATA", 0);
                CustomItem customItem = new CustomItem(displayName, material, lore, slot, command, customModelData);
                this.items.get(profileState).addItem(customItem, slot);
            }
        }
    }

    @Override
    public void save() {
    }

    @Override
    public ConfigFile getConfigFile() {
        return ConfigService.get().getHotbarConfig();
    }

    @Generated
    public Map<ProfileState, Hotbar> getItems() {
        return this.items;
    }

    @Generated
    public Neptune getPlugin() {
        return this.plugin;
    }
}

