/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.hotbar.impl;

import dev.lrxh.neptune.feature.hotbar.HotbarService;
import dev.lrxh.neptune.feature.hotbar.impl.Hotbar;
import dev.lrxh.neptune.feature.hotbar.impl.ItemAction;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.utils.ItemBuilder;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Item {
    private final ItemAction action;
    private final String displayName;
    private final String material;
    private final List<String> lore;
    private final boolean enabled;
    private final byte slot;
    private final int customModelData;

    public static Item getByItemStack(ProfileState profileState, ItemStack itemStack, UUID playerUUID) {
        Hotbar inventory = HotbarService.get().getItems().get(profileState);
        return Item.getItemFromInventory(itemStack, inventory, playerUUID);
    }

    private static Item getItemFromInventory(ItemStack itemStack, Hotbar inventory, UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return null;
        }
        if (inventory != null) {
            for (int slot = 0; slot <= 8; ++slot) {
                Item item = HotbarService.get().getItemForSlot(inventory, slot);
                if (item == null || !item.constructItem(playerUUID).getItemMeta().getDisplayName().equals(itemStack.getItemMeta().getDisplayName())) continue;
                return item;
            }
        }
        return null;
    }

    public ItemStack constructItem(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return new ItemStack(Material.BARRIER);
        }
        return new ItemBuilder(this.material, playerUUID).name(this.displayName).makeUnbreakable().lore(this.lore).setCustomModelData(this.customModelData).build();
    }

    @Generated
    public ItemAction getAction() {
        return this.action;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getMaterial() {
        return this.material;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public byte getSlot() {
        return this.slot;
    }

    @Generated
    public int getCustomModelData() {
        return this.customModelData;
    }

    @Generated
    public Item(ItemAction action, String displayName, String material, List<String> lore, boolean enabled, byte slot, int customModelData) {
        this.action = action;
        this.displayName = displayName;
        this.material = material;
        this.lore = lore;
        this.enabled = enabled;
        this.slot = slot;
        this.customModelData = customModelData;
    }
}

