/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.itembrowser;

import dev.lrxh.neptune.feature.itembrowser.ItemBrowserService;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.PaginatedMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ItemBrowserMenu
extends PaginatedMenu {
    private final ItemBrowserService service;
    private final String section;
    private final Consumer<Material> itemConsumer;
    private final Runnable returnConsumer;
    private final String search;

    public ItemBrowserMenu(ItemBrowserService service, String section, Consumer<Material> itemConsumer, String search, Runnable returnConsumer) {
        super("&fItem Browser", 54, Filter.NONE);
        this.service = service;
        this.section = section;
        this.itemConsumer = itemConsumer;
        this.search = search == null ? "" : search;
        this.returnConsumer = returnConsumer;
    }

    @Override
    public List<Button> getAllPagesButtons(Player player) {
        List<Object> items = this.service.getItems(this.section);
        if (!this.search.isEmpty()) {
            items = items.stream().filter(mat -> mat.name().toLowerCase().contains(this.search.toLowerCase())).collect(Collectors.toList());
        }
        ArrayList<Button> buttons = new ArrayList<Button>();
        int i = 0;
        for (final Material mat2 : items) {
            if (!mat2.isItem()) continue;
            buttons.add(new Button(i++){

                @Override
                public ItemStack getItemStack(Player p) {
                    return new ItemBuilder(mat2).name("&f" + mat2.name()).build();
                }

                @Override
                public void onClick(ClickType type, Player p) {
                    ItemBrowserMenu.this.itemConsumer.accept(mat2);
                    p.closeInventory();
                }
            });
        }
        return buttons;
    }

    @Override
    public List<Button> getGlobalButtons(Player player) {
        ArrayList<Button> global = new ArrayList<Button>();
        global.add(new Button(45){

            @Override
            public ItemStack getItemStack(Player p) {
                return new ItemBuilder(Material.OAK_SIGN).name("&eSearch").build();
            }

            @Override
            public void onClick(ClickType type, Player p) {
                ItemBrowserMenu.this.service.requestSearch(p, ItemBrowserMenu.this.section, ItemBrowserMenu.this.itemConsumer, ItemBrowserMenu.this.returnConsumer);
            }
        });
        global.add(new Button(49){

            @Override
            public ItemStack getItemStack(Player p) {
                return new ItemBuilder(Material.ARROW).name("&cReturn").build();
            }

            @Override
            public void onClick(ClickType type, Player p) {
                if (ItemBrowserMenu.this.returnConsumer != null) {
                    ItemBrowserMenu.this.returnConsumer.run();
                    p.closeInventory();
                }
            }
        });
        return global;
    }

    @Override
    public int getMaxItemsPerPage() {
        return 36;
    }
}

