/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.itembrowser;

import dev.lrxh.api.features.IItemBrowserService;
import dev.lrxh.neptune.feature.itembrowser.ItemBrowserMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ItemBrowserService
implements IItemBrowserService {
    private static ItemBrowserService instance;
    private final Map<String, List<Material>> sectionMaterials = new HashMap<String, List<Material>>();
    private final Map<UUID, SearchSession> searchSessions = new HashMap<UUID, SearchSession>();
    private final List<Material> cachedMaterials = new ArrayList<Material>();

    public ItemBrowserService() {
        Arrays.stream(Material.values()).filter(m -> m != Material.AIR).forEach(this.cachedMaterials::add);
    }

    public static ItemBrowserService get() {
        if (instance == null) {
            instance = new ItemBrowserService();
        }
        return instance;
    }

    @Override
    public List<Material> getItems(String section) {
        if (section.equals("blocks")) {
            return this.getBlocks();
        }
        return this.sectionMaterials.getOrDefault(section, Collections.emptyList());
    }

    public List<Material> getBlocks() {
        return this.cachedMaterials.stream().filter(Material::isBlock).toList();
    }

    @Override
    public void openBrowser(Player player, String section, Consumer<Material> itemConsumer, Runnable returnConsumer) {
        this.openBrowser(player, section, itemConsumer, "", returnConsumer);
    }

    public void openBrowser(Player player, String section, Consumer<Material> itemConsumer, String search, Runnable returnConsumer) {
        new ItemBrowserMenu(ItemBrowserService.get(), section, itemConsumer, search, returnConsumer).open(player);
    }

    public void requestSearch(Player player, String section, Consumer<Material> itemConsumer, Runnable returnConsumer) {
        player.closeInventory();
        player.sendMessage("\u00a7ePlease type your search in chat.");
        this.searchSessions.put(player.getUniqueId(), new SearchSession(section, itemConsumer, returnConsumer));
    }

    public SearchSession removeSearchSession(UUID uuid) {
        return this.searchSessions.remove(uuid);
    }

    @Override
    public void registerSection(String section, List<String> materialNames) {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (String matName : materialNames) {
            Material mat = Material.matchMaterial((String)matName);
            if (mat == null || !mat.isItem()) continue;
            materials.add(mat);
        }
        this.sectionMaterials.put(section, materials);
    }

    record SearchSession(String section, Consumer<Material> itemConsumer, Runnable returnConsumer) {
    }
}

