/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.leaderboard.impl;

import dev.lrxh.neptune.feature.leaderboard.impl.LeaderboardType;
import dev.lrxh.neptune.feature.leaderboard.impl.PlayerEntry;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class LeaderboardEntry {
    private final LeaderboardType type;
    private List<PlayerEntry> playerEntries;

    public void addEntry(PlayerEntry playerEntry) {
        PlayerEntry oldEntry = this.getPlayer(playerEntry.getUuid());
        if (oldEntry != null) {
            this.playerEntries.remove(oldEntry);
        }
        this.playerEntries.add(playerEntry);
        this.playerEntries = this.playerEntries.stream().sorted(Comparator.comparingInt(PlayerEntry::getValue).reversed()).limit(10L).collect(Collectors.toList());
    }

    public PlayerEntry getPlayer(UUID playerUUID) {
        for (PlayerEntry playerEntry : this.playerEntries) {
            if (!playerEntry.getUuid().equals(playerUUID)) continue;
            return playerEntry;
        }
        return null;
    }

    @Generated
    public LeaderboardEntry(LeaderboardType type, List<PlayerEntry> playerEntries) {
        this.type = type;
        this.playerEntries = playerEntries;
    }

    @Generated
    public LeaderboardType getType() {
        return this.type;
    }

    @Generated
    public List<PlayerEntry> getPlayerEntries() {
        return this.playerEntries;
    }
}

