/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.leaderboard.impl;

import dev.lrxh.neptune.profile.data.KitData;
import javax.annotation.Nullable;
import lombok.Generated;

public enum LeaderboardType {
    KILLS("Kills", "KILLS", "WINS"){

        @Override
        public int get(KitData kitData) {
            return kitData.getKills();
        }
    }
    ,
    BEST_WIN_STREAK("Best Win Streak", "BEST_WIN_STREAK", "WIN_STREAK_BEST"){

        @Override
        public int get(KitData kitData) {
            return kitData.getBestStreak();
        }
    }
    ,
    ELO("Elo", "ELO", "ELO"){

        @Override
        public int get(KitData kitData) {
            return kitData.getElo();
        }
    }
    ,
    DEATHS("Deaths", "DEATHS", "LOSSES"){

        @Override
        public int get(KitData kitData) {
            return kitData.getDeaths();
        }
    };

    private final String name;
    private final String configName;
    private final String databaseName;

    @Nullable
    public static LeaderboardType value(String value) {
        for (LeaderboardType leaderboardType : LeaderboardType.values()) {
            if (!leaderboardType.toString().equalsIgnoreCase(value)) continue;
            return leaderboardType;
        }
        return null;
    }

    public abstract int get(KitData var1);

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getConfigName() {
        return this.configName;
    }

    @Generated
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Generated
    private LeaderboardType(String name, String configName, String databaseName) {
        this.name = name;
        this.configName = configName;
        this.databaseName = databaseName;
    }
}

