/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.leaderboard.menu;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.leaderboard.LeaderboardService;
import dev.lrxh.neptune.feature.leaderboard.impl.LeaderboardType;
import dev.lrxh.neptune.feature.leaderboard.impl.PlayerEntry;
import dev.lrxh.neptune.feature.leaderboard.menu.button.LeaderboardSwitchButton;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.KitService;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.Menu;
import dev.lrxh.neptune.utils.menu.impl.DisplayButton;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LeaderboardMenu
extends Menu {
    private final LeaderboardType leaderboardType;

    public LeaderboardMenu(LeaderboardType leaderboardType) {
        super(MenusLocale.valueOf("LEADERBOARD_TYPES_" + leaderboardType.getConfigName() + "_TITLE").getString(), MenusLocale.LEADERBOARD_SIZE.getInt(), Filter.valueOf(MenusLocale.LEADERBOARD_FILTER.getString()));
        this.leaderboardType = leaderboardType;
        this.setUpdateEveryTick(true);
    }

    @Override
    public List<Button> getButtons(Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (Kit kit : KitService.get().kits) {
            if (kit.getRules().get(KitRule.HIDDEN).booleanValue()) continue;
            buttons.add(new DisplayButton(kit.getSlot(), this.buildKitItem(player, kit)));
        }
        for (LeaderboardType type : LeaderboardType.values()) {
            buttons.add(this.buildSwitchButton(type));
        }
        return buttons;
    }

    private LeaderboardSwitchButton buildSwitchButton(LeaderboardType type) {
        boolean isSelected = type == this.leaderboardType;
        String state = isSelected ? "ENABLED" : "DISABLED";
        String baseKey = "LEADERBOARD_TYPES_" + type.getConfigName();
        return new LeaderboardSwitchButton(MenusLocale.valueOf(baseKey + "_SLOT").getInt(), type, MenusLocale.valueOf(baseKey + "_" + state + "_NAME").getString(), MenusLocale.valueOf(baseKey + "_" + state + "_LORE").getStringList(), Material.valueOf((String)MenusLocale.valueOf(baseKey + "_" + state + "_MATERIAL").getString()));
    }

    private ItemStack buildKitItem(Player player, Kit kit) {
        List<String> lore = this.buildKitLore(kit);
        return new ItemBuilder(kit.getIcon()).name(MenusLocale.LEADERBOARD_ITEM_NAME.getString().replace("<kit>", kit.getDisplayName())).lore(lore, player).build();
    }

    private List<String> buildKitLore(Kit kit) {
        List<PlayerEntry> leaderboard = LeaderboardService.get().getPlayerEntries(kit, this.leaderboardType);
        ArrayList<String> lore = new ArrayList<String>();
        for (String templateLine : MenusLocale.LEADERBOARD_LORE.getStringList()) {
            lore.add(this.replaceLeaderboardPlaceholders(templateLine, kit, leaderboard));
        }
        return lore;
    }

    private String replaceLeaderboardPlaceholders(String template, Kit kit, List<PlayerEntry> leaderboard) {
        String result = template;
        for (int i = 1; i <= 10; ++i) {
            PlayerEntry entry = this.getEntryAtPosition(kit, leaderboard, i);
            String player = entry != null && entry.getUsername() != null ? entry.getUsername() : "???";
            String value = entry != null ? String.valueOf(entry.getValue()) : "???";
            result = result.replace("<player_" + i + ">", player).replace("<value_" + i + ">", value);
        }
        return result;
    }

    private PlayerEntry getEntryAtPosition(Kit kit, List<PlayerEntry> leaderboard, int position) {
        return position <= leaderboard.size() ? LeaderboardService.get().getLeaderboardSlot(kit, this.leaderboardType, position) : null;
    }
}

