/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.leaderboard.menu.button;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.leaderboard.LeaderboardService;
import dev.lrxh.neptune.feature.leaderboard.impl.LeaderboardType;
import dev.lrxh.neptune.feature.leaderboard.impl.PlayerEntry;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LeaderboardButton
extends Button {
    private final Kit kit;
    private final LeaderboardType leaderboardType;

    public LeaderboardButton(int slot, Kit kit, LeaderboardType leaderboardType) {
        super(slot);
        this.kit = kit;
        this.leaderboardType = leaderboardType;
    }

    @Override
    public ItemStack getItemStack(Player player) {
        ArrayList<String> lore = new ArrayList<String>();
        List<PlayerEntry> leaderboard = LeaderboardService.get().getPlayerEntries(this.kit, this.leaderboardType);
        MenusLocale.LEADERBOARD_LORE.getStringList().forEach(line -> {
            for (int i = 1; i <= 10; ++i) {
                PlayerEntry playerEntry = null;
                if (i <= leaderboard.size()) {
                    playerEntry = LeaderboardService.get().getLeaderboardSlot(this.kit, this.leaderboardType, i);
                }
                if (playerEntry == null) {
                    line = line.replaceAll("<player_" + i + ">", "???");
                    line = line.replaceAll("<value_" + i + ">", "???");
                    continue;
                }
                line = line.replaceAll("<player_" + i + ">", playerEntry.getUsername());
                line = line.replaceAll("<value_" + i + ">", String.valueOf(playerEntry.getValue()));
            }
            lore.add((String)line);
        });
        return new ItemBuilder(this.kit.getIcon()).name(MenusLocale.LEADERBOARD_ITEM_NAME.getString().replace("<kit>", this.kit.getDisplayName())).lore(lore, player).build();
    }
}

